/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ContainerLifecycleEventPreloader;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.executor.IterativeWorkerTaskFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.util.collections.ConcurrentHashSetSupplier;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentBeanDeployer
extends BeanDeployer {
    private final ExecutorServices executor;
    private final ContainerLifecycleEventPreloader preloader;

    public ConcurrentBeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        super(manager, ejbDescriptors, services, BeanDeployerEnvironment.newConcurrentEnvironment(ejbDescriptors, manager));
        this.executor = services.get(ExecutorServices.class);
        this.preloader = services.get(ContainerLifecycleEventPreloader.class);
        if (this.preloader == null) {
            throw new IllegalArgumentException(ContainerLifecycleEventPreloader.class.getName() + " is null");
        }
    }

    @Override
    protected void preloadContainerLifecycleEvent(Class<?> eventRawType, Type ... typeParameters) {
        this.preloader.preloadContainerLifecycleEvent(this.getManager(), eventRawType, typeParameters);
    }

    @Override
    public BeanDeployer addClasses(Iterable<String> c) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<String>(c){

            @Override
            protected void doWork(String className) {
                ConcurrentBeanDeployer.this.addClass(className);
            }
        });
        return this;
    }

    @Override
    public void createClassBeans() {
        final SetMultimap otherWeldClasses = Multimaps.newSetMultimap(new ConcurrentHashMap(), new ConcurrentHashSetSupplier());
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<AnnotatedType<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()){

            @Override
            protected void doWork(AnnotatedType<?> weldClass) {
                ConcurrentBeanDeployer.this.createClassBean(weldClass, otherWeldClasses);
            }
        });
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<InternalEjbDescriptor<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()){

            @Override
            protected void doWork(InternalEjbDescriptor<?> descriptor) {
                if (!((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment()).isVetoed(descriptor.getBeanClass()) && (descriptor.isSingleton() || descriptor.isStateful() || descriptor.isStateless())) {
                    if (otherWeldClasses.containsKey(descriptor.getBeanClass())) {
                        for (AnnotatedType annotatedType : otherWeldClasses.get(descriptor.getBeanClass())) {
                            EnhancedAnnotatedType weldClass = ConcurrentBeanDeployer.this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                            ConcurrentBeanDeployer.this.createSessionBean(descriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                        }
                    } else {
                        ConcurrentBeanDeployer.this.createSessionBean(descriptor);
                    }
                }
            }
        });
    }

    @Override
    public void createProducersAndObservers() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<AbstractClassBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values()){

            @Override
            protected void doWork(AbstractClassBean<?> bean) {
                ConcurrentBeanDeployer.this.createObserversProducersDisposers(bean);
            }
        });
    }

    @Override
    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<Bean<?>>(beanList){

            @Override
            protected void doWork(Bean<?> bean) {
                if (bean instanceof RIBean) {
                    ((RIBean)bean).initializeAfterBeanDiscovery();
                }
            }
        });
    }

    @Override
    public AbstractBeanDeployer<BeanDeployerEnvironment> initializeBeans() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<RIBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getBeans()){

            @Override
            protected void doWork(RIBean<?> bean) {
                bean.initialize((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment());
            }
        });
        return this;
    }
}

