/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.executor.DeamonThreadFactory;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerLifecycleEventPreloader
implements Service {
    private static final long SHUTDOWN_TIMEOUT = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors() - 1;
    private final ExecutorService executor;

    public ContainerLifecycleEventPreloader() {
        this(DEFAULT_THREAD_COUNT);
    }

    public ContainerLifecycleEventPreloader(int threadCount) {
        this.executor = Executors.newFixedThreadPool(threadCount, new DeamonThreadFactory(new ThreadGroup("weld-preloaders"), "weld-preloader-"));
    }

    public void preloadContainerLifecycleEvent(BeanManagerImpl manager, Class<?> eventRawType, Type ... typeParameters) {
        this.executor.submit(new PreloadingTask(new ParameterizedTypeImpl(eventRawType, typeParameters, null), manager));
    }

    @Override
    public void cleanup() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    log.warn(BootstrapMessage.TIMEOUT_SHUTTING_DOWN_THREAD_POOL, this.executor, this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void shutdown() {
        ContainerLifecycleEventPreloader instance = Container.instance().services().get(ContainerLifecycleEventPreloader.class);
        if (instance != null) {
            instance.cleanup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreloadingTask
    implements Callable<Void> {
        private final Type type;
        private final BeanManagerImpl manager;

        public PreloadingTask(Type type, BeanManagerImpl manager) {
            this.type = type;
            this.manager = manager;
        }

        @Override
        public Void call() throws Exception {
            this.manager.resolveObserverMethods(this.type, new Annotation[0]);
            return null;
        }
    }
}

