/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Named;
import javax.inject.Scope;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.NullableDependencyException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.literal.DecoratedLiteral;
import org.jboss.weld.literal.InterceptedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements Service {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);

    protected void validateGeneralBean(Bean<?> bean, BeanManagerImpl beanManager) {
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw Proxies.getUnproxyableTypesException(bean);
        }
        if (!normalScoped) {
            Validator.validatePseudoScopedBean(bean, beanManager);
        }
    }

    protected void validateRIBean(RIBean<?> bean, BeanManagerImpl beanManager, Collection<RIBean<?>> specializedBeans) {
        this.validateGeneralBean(bean, beanManager);
        if (!(bean instanceof NewManagedBean) && !(bean instanceof NewSessionBean)) {
            boolean added;
            RIBean<?> abstractBean = bean;
            if (abstractBean.isSpecializing() && !(added = specializedBeans.add(abstractBean.getSpecializedBean()))) {
                throw new InconsistentSpecializationException(ValidatorMessage.BEAN_SPECIALIZED_TOO_MANY_TIMES, bean);
            }
            if (bean instanceof AbstractClassBean) {
                AbstractClassBean classBean = (AbstractClassBean)bean;
                if (classBean.hasDecorators()) {
                    this.validateDecorators(beanManager, classBean);
                }
                if (classBean.hasInterceptors()) {
                    this.validateInterceptors(beanManager, classBean);
                }
            }
            if (bean instanceof AbstractProducerBean && ((AbstractProducerBean)bean).getDisposalMethod() != null) {
                DisposalMethod disposalMethod = ((AbstractProducerBean)bean).getDisposalMethod();
                for (InjectionPoint ip : disposalMethod.getInjectionPoints()) {
                    this.validateInjectionPoint(ip, bean, beanManager);
                }
            }
        }
    }

    private void validateInterceptors(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Set interceptors;
        InterceptionModel interceptionModel = (InterceptionModel)beanManager.getInterceptorModelRegistry().get(classBean.getType());
        if (interceptionModel != null && (interceptors = interceptionModel.getAllInterceptors()).size() > 0) {
            boolean passivationCapabilityCheckRequired = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(classBean.getScope()).isPassivating();
            for (InterceptorMetadata interceptorMetadata : interceptors) {
                if (interceptorMetadata.getInterceptorReference().getInterceptor() instanceof SerializableContextual) {
                    SerializableContextual serializableContextual = (SerializableContextual)Reflections.cast(interceptorMetadata.getInterceptorReference().getInterceptor());
                    if (passivationCapabilityCheckRequired) {
                        boolean isSerializable;
                        Interceptor interceptor = (Interceptor)serializableContextual.get();
                        boolean bl = isSerializable = interceptor instanceof InterceptorImpl ? ((InterceptorImpl)interceptor).isSerializable() : interceptor instanceof PassivationCapable;
                        if (!isSerializable) {
                            throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, classBean, interceptor);
                        }
                    }
                    for (InjectionPoint injectionPoint : ((Interceptor)serializableContextual.get()).getInjectionPoints()) {
                        Bean resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                        this.validateInjectionPoint(injectionPoint, beanManager);
                        if (!passivationCapabilityCheckRequired) continue;
                        this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                    }
                }
                if (!(interceptorMetadata.getInterceptorReference().getInterceptor() instanceof ClassMetadata)) continue;
                ClassMetadata classMetadata = (ClassMetadata)interceptorMetadata.getInterceptorReference().getInterceptor();
                if (passivationCapabilityCheckRequired && !Reflections.isSerializable(classMetadata.getJavaClass())) {
                    throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, this, classMetadata.getJavaClass().getName());
                }
                InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(beanManager.createInjectionTarget(beanManager.createAnnotatedType(classMetadata.getJavaClass())));
                for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                    this.validateInjectionPoint(injectionPoint, beanManager);
                    if (!passivationCapabilityCheckRequired) continue;
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateDecorators(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        if (classBean.getDecorators().size() > 0) {
            boolean passivationCapabilityCheckRequired = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(classBean.getScope()).isPassivating();
            for (Decorator<?> decorator : classBean.getDecorators()) {
                if (passivationCapabilityCheckRequired) {
                    boolean isSerializable;
                    boolean bl = isSerializable = decorator instanceof WeldDecorator ? ((WeldDecorator)decorator).getEnhancedAnnotated().isSerializable() : decorator instanceof PassivationCapable;
                    if (!isSerializable) {
                        throw new UnserializableDependencyException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_DECORATOR, classBean, decorator);
                    }
                }
                for (InjectionPoint ij : decorator.getInjectionPoints()) {
                    if (ij.isDelegate()) continue;
                    Bean resolvedBean = beanManager.resolve(beanManager.getBeans(ij));
                    this.validateInjectionPoint(ij, beanManager);
                    if (!passivationCapabilityCheckRequired) continue;
                    this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
                }
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        this.validateInjectionPoint(ij, ij.getBean(), beanManager);
    }

    public void validateInjectionPoint(InjectionPoint ij, Bean<?> bean, BeanManagerImpl beanManager) {
        boolean newBean;
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException(ValidatorMessage.NEW_WITH_QUALIFIERS, ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, ij);
        }
        if (!(ij.getMember() instanceof Field) && ij.getAnnotated().isAnnotationPresent(Named.class) && ij.getAnnotated().getAnnotation(Named.class).value().equals("")) {
            throw new DefinitionException(ValidatorMessage.NON_FIELD_INJECTION_POINT_CANNOT_USE_NAMED, ij);
        }
        boolean bl = newBean = bean instanceof NewManagedBean || bean instanceof NewSessionBean;
        if (!newBean) {
            this.checkScopeAnnotations(ij, beanManager.getServices().get(MetaAnnotationStore.class));
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        Annotation[] bindings = ij.getQualifiers().toArray(new Annotation[0]);
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getBeans(ij));
        if (!Validator.isInjectionPointSatisfied(ij, resolvedBeans, beanManager)) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_UNSATISFIED_DEPENDENCIES, ij, Formats.formatAnnotations(bindings), Formats.formatType(ij.getType()));
        }
        if (resolvedBeans.size() > 1 && !ij.isDelegate()) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_AMBIGUOUS_DEPENDENCIES, ij, Formats.formatAnnotations(bindings), Formats.formatType(ij.getType()), resolvedBeans);
        }
        if (!resolvedBeans.isEmpty()) {
            UnproxyableResolutionException ue;
            Bean resolvedBean = resolvedBeans.iterator().next();
            if (beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScope()).isNormal() && (ue = Proxies.getUnproxyableTypeException(ij.getType())) != null) {
                UnproxyableResolutionException exception = new UnproxyableResolutionException(ValidatorMessage.INJECTION_POINT_HAS_NON_PROXYABLE_DEPENDENCIES, ij);
                exception.initCause(ue);
                throw exception;
            }
            if (Reflections.isPrimitive(ij.getType()) && resolvedBean.isNullable()) {
                throw new NullableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NULLABLE_DEPENDENCIES, ij);
            }
            if (bean != null && Beans.isPassivatingScope(bean, beanManager)) {
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
        if (ij.getType().equals(InjectionPoint.class) && bean == null) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_BEAN, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals(bean.getScope())) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_DEPENDENT_BEAN, ij);
        }
        Class rawType = Reflections.getRawType(ij.getType());
        if (Bean.class.equals(rawType) || Interceptor.class.equals(rawType) || Decorator.class.equals(rawType)) {
            if (bean == null) {
                throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_BEAN, ij);
            }
            if (rawType.equals(Interceptor.class) && !(bean instanceof Interceptor)) {
                throw new DefinitionException(ValidatorMessage.CANNOT_INJECT_BEAN_METADATA, ij.getQualifiers(), Interceptor.class.getSimpleName(), ij);
            }
            if (rawType.equals(Decorator.class) && !(bean instanceof Decorator)) {
                throw new DefinitionException(ValidatorMessage.CANNOT_INJECT_BEAN_METADATA, ij.getQualifiers(), Decorator.class.getSimpleName(), ij);
            }
            if (rawType.equals(Bean.class) && ij.getQualifiers().contains(InterceptedLiteral.INSTANCE) && !(bean instanceof Interceptor) || rawType.equals(Bean.class) && ij.getQualifiers().contains(DecoratedLiteral.INSTANCE) && !(bean instanceof Decorator)) {
                throw new DefinitionException(ValidatorMessage.CANNOT_INJECT_BEAN_METADATA, ij.getQualifiers(), Bean.class.getSimpleName(), ij);
            }
        }
    }

    public void validateInjectionTargets(Collection<InjectionTarget<?>> injectionTargets, BeanManagerImpl beanManager) {
        for (InjectionTarget<?> injectionTarget : injectionTargets) {
            this.validateInjectionTarget(injectionTarget, beanManager);
        }
    }

    public void validateInjectionTarget(InjectionTarget<?> injectionTarget, BeanManagerImpl beanManager) {
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            this.validateInjectionPoint(injectionPoint, beanManager);
        }
    }

    private void checkScopeAnnotations(InjectionPoint ij, MetaAnnotationStore metaAnnotationStore) {
        Annotated annotated = ij.getAnnotated();
        if (annotated instanceof EnhancedAnnotated) {
            EnhancedAnnotated weldAnnotated = (EnhancedAnnotated)annotated;
            Set<Annotation> scopes = weldAnnotated.getMetaAnnotations(Scope.class);
            Set<Annotation> normalScopes = weldAnnotated.getMetaAnnotations(NormalScope.class);
            for (Annotation annotation : scopes) {
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
            for (Annotation annotation : normalScopes) {
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
        } else {
            for (Annotation annotation : annotated.getAnnotations()) {
                if (!this.hasScopeMetaAnnotation(annotation)) continue;
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
        }
    }

    private void logScopeOnInjectionPointWarning(InjectionPoint ij, Annotation annotation) {
        log.warn(ValidatorMessage.SCOPE_ANNOTATION_ON_INJECTION_POINT, annotation, ij);
    }

    private boolean hasScopeMetaAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class);
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (ij.getMember() instanceof Field && !ij.isTransient() && !Beans.isPassivationCapableDependency(resolvedBean)) {
            if (resolvedBean.getScope().equals(Dependent.class) && resolvedBean instanceof AbstractProducerBean) {
                throw new IllegalProductException(ValidatorMessage.NON_SERIALIZABLE_BEAN_INJECTED_INTO_PASSIVATING_BEAN, ij.getBean(), resolvedBean);
            }
            throw new UnserializableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NON_SERIALIZABLE_DEPENDENCY, ij.getBean(), resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.validateDecorators(manager.getDecorators(), manager);
        this.validateInterceptors(manager.getInterceptors());
        this.validateBeans(manager.getBeans(), manager);
        this.validateEnabledDecoratorClasses(manager);
        this.validateEnabledInterceptorClasses(manager);
        this.validateEnabledAlternatives(manager);
        this.validateDisposalMethods(environment);
        this.validateObserverMethods(environment.getObservers(), manager);
        this.validateBeanNames(manager);
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, BeanManagerImpl manager) {
        ArrayList<RuntimeException> problems = new ArrayList<RuntimeException>();
        HashSet specializedBeans = new HashSet();
        for (Bean<?> bean : beans) {
            this.validateBean(bean, specializedBeans, manager, problems);
        }
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (RuntimeException)problems.get(0);
            }
            throw new DeploymentException(problems);
        }
    }

    protected void validateBean(Bean<?> bean, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager, List<RuntimeException> problems) {
        try {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
            } else {
                this.validateGeneralBean(bean, manager);
            }
        }
        catch (RuntimeException e) {
            problems.add(e);
        }
    }

    public void validateInterceptors(Collection<? extends Interceptor<?>> interceptors) {
        for (Interceptor<?> interceptor : interceptors) {
            this.validateInterceptor(interceptor);
        }
    }

    protected void validateInterceptor(Interceptor<?> interceptor) {
        if (interceptor instanceof InterceptorImpl) {
            for (EnhancedAnnotatedType annotated = ((InterceptorImpl)interceptor).getEnhancedAnnotated(); annotated != null && annotated.getJavaClass() != Object.class; annotated = annotated.getEnhancedSuperclass()) {
                if (!annotated.getDeclaredEnhancedMethods(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_METHODS, interceptor);
                }
                if (!annotated.getDeclaredEnhancedFields(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_FIELDS, interceptor);
                }
                if (!annotated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_DISPOSER_METHODS, interceptor);
                }
                if (annotated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Observes.class).isEmpty()) continue;
                throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_OBSERVER_METHODS, interceptor);
            }
        }
    }

    public void validateDecorators(Collection<? extends Decorator<?>> decorators, BeanManagerImpl manager) {
        HashSet specializedBeans = new HashSet();
        for (Decorator<?> decorator : decorators) {
            this.validateDecorator(decorator, specializedBeans, manager);
        }
    }

    protected void validateDecorator(Decorator<?> decorator, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        if (decorator instanceof RIBean) {
            this.validateRIBean((RIBean)((Object)decorator), manager, specializedBeans);
            if (decorator instanceof WeldDecorator) {
                for (EnhancedAnnotatedType<?> annotatated = ((WeldDecorator)decorator).getEnhancedAnnotated(); annotatated != null && annotatated.getJavaClass() != Object.class; annotatated = annotatated.getEnhancedSuperclass()) {
                    if (!annotatated.getDeclaredEnhancedMethods(Produces.class).isEmpty()) {
                        throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_METHODS, decorator);
                    }
                    if (!annotatated.getDeclaredEnhancedFields(Produces.class).isEmpty()) {
                        throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_FIELDS, decorator);
                    }
                    if (!annotatated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) {
                        throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_DISPOSER_METHODS, decorator);
                    }
                    if (annotatated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Observes.class).isEmpty()) continue;
                    throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_OBSERVER_METHODS, decorator);
                }
            }
        } else {
            this.validateGeneralBean(decorator, manager);
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap<String, Bean<?>> namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Bean<?>>>(){

            @Override
            public Set<Bean<?>> get() {
                return new HashSet();
            }
        });
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put(bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(Beans.removeDisabledAndSpecializedBeans(namedAccessibleBeans.get(name), beanManager));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException(ValidatorMessage.AMBIGUOUS_EL_NAME, name, resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException(ValidatorMessage.BEAN_NAME_IS_PREFIX, name);
        }
    }

    private void validateEnabledInterceptorClasses(BeanManagerImpl beanManager) {
        HashSet interceptorBeanClasses = new HashSet();
        for (Interceptor<?> interceptor : beanManager.getAccessibleInterceptors()) {
            interceptorBeanClasses.add(interceptor.getBeanClass());
        }
        for (Metadata metadata : beanManager.getEnabled().getInterceptors()) {
            if (interceptorBeanClasses.contains(metadata.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.INTERCEPTOR_NOT_ANNOTATED_OR_REGISTERED, metadata);
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager) {
        HashSet decoratorBeanClasses = new HashSet();
        for (Decorator<?> decorator : beanManager.getAccessibleDecorators()) {
            decoratorBeanClasses.add(decorator.getBeanClass());
        }
        for (Metadata metadata : beanManager.getEnabled().getDecorators()) {
            if (decoratorBeanClasses.contains(metadata.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.DECORATOR_CLASS_NOT_BEAN_CLASS_OF_DECORATOR, metadata, decoratorBeanClasses);
        }
    }

    private void validateEnabledAlternatives(BeanManagerImpl beanManager) {
        for (Metadata<Class<? extends Annotation>> stereotype : beanManager.getEnabled().getAlternativeStereotypes()) {
            if (!beanManager.isStereotype(stereotype.getValue())) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_STEREOTYPE, stereotype);
            }
            if (Validator.isAlternative(beanManager, stereotype.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_ANNOTATED, stereotype);
        }
        if (beanManager.getEnabled().getAlternativeClasses().size() > 0) {
            HashMultimap<Class<Object>, Bean<?>> beansByClass = HashMultimap.create();
            for (Bean<?> bean : beanManager.getAccessibleBeans()) {
                if (bean instanceof NewBean) continue;
                beansByClass.put(bean.getBeanClass(), bean);
            }
            for (Metadata metadata : beanManager.getEnabled().getAlternativeClasses()) {
                if (((Class)metadata.getValue()).isAnnotation() || ((Class)metadata.getValue()).isInterface()) {
                    throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_CLASS, metadata);
                }
                boolean alternativeBeanFound = false;
                for (Bean bean : beansByClass.get((Class<Object>)metadata.getValue())) {
                    if (!bean.isAlternative()) continue;
                    alternativeBeanFound = true;
                }
                if (alternativeBeanFound) continue;
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_ANNOTATED, metadata);
            }
        }
    }

    private static boolean isAlternative(BeanManager beanManager, Class<? extends Annotation> stereotype) {
        for (Annotation annotation : beanManager.getStereotypeDefinition(stereotype)) {
            if (!annotation.annotationType().equals(Alternative.class)) continue;
            return true;
        }
        return false;
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?, ?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException(ValidatorMessage.DISPOSAL_METHODS_WITHOUT_PRODUCER, beans);
        }
    }

    protected void validateObserverMethods(Iterable<ObserverInitializationContext<?, ?>> observers, BeanManagerImpl beanManager) {
        for (ObserverInitializationContext<?, ?> omi : observers) {
            for (WeldInjectionPoint<?, ?> ip : omi.getObserver().getInjectionPoints()) {
                this.validateInjectionPoint(ip, beanManager);
            }
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        if (injectionPoint.getAnnotated().getBaseType().equals(type)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_HAS_WILDCARD, type, injectionPoint);
                }
            } else {
                throw new DefinitionException(ValidatorMessage.INJECTION_POINT_MUST_HAVE_TYPE_PARAMETER, type, injectionPoint);
            }
        }
    }

    private static boolean isInjectionPointSatisfied(InjectionPoint ij, Set<?> resolvedBeans, BeanManagerImpl beanManager) {
        if (ij.getBean() instanceof Decorator) {
            if (beanManager.getEnabled().getDecorator(ij.getBean().getBeanClass()) != null) {
                return resolvedBeans.size() > 0;
            }
            return true;
        }
        return resolvedBeans.size() > 0;
    }

    private static void validatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager) {
        Validator.reallyValidatePseudoScopedBean(bean, beanManager, new LinkedHashSet(), new HashSet());
    }

    private static void reallyValidatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager, Set<Bean<?>> dependencyPath, Set<Bean<?>> validatedBeans) {
        if (dependencyPath.contains(bean)) {
            ArrayList realDepdencyPath = new ArrayList(dependencyPath);
            realDepdencyPath.add(bean);
            throw new DeploymentException(ValidatorMessage.PSEUDO_SCOPED_BEAN_HAS_CIRCULAR_REFERENCES, realDepdencyPath);
        }
        if (validatedBeans.contains(bean)) {
            return;
        }
        dependencyPath.add(bean);
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            if (injectionPoint.isDelegate()) continue;
            Validator.validatePseudoScopedInjectionPoint(injectionPoint, beanManager, dependencyPath, validatedBeans);
        }
        if (bean instanceof AbstractClassBean && ((AbstractClassBean)bean).hasDecorators()) {
            List<Decorator<?>> decorators = ((AbstractClassBean)bean).getDecorators();
            for (Decorator<?> decorator : decorators) {
                Validator.reallyValidatePseudoScopedBean(decorator, beanManager, dependencyPath, validatedBeans);
            }
        }
        validatedBeans.add(bean);
        dependencyPath.remove(bean);
    }

    private static void validatePseudoScopedInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager, Set<Bean<?>> dependencyPath, Set<Bean<?>> validatedBeans) {
        boolean normalScoped;
        Set resolved = beanManager.getBeans(ij);
        Bean bean = beanManager.resolve(resolved);
        if (!(bean == null || bean instanceof AbstractBuiltInBean || ij.isDelegate() || (normalScoped = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal()))) {
            Validator.reallyValidatePseudoScopedBean(bean, beanManager, dependencyPath, validatedBeans);
        }
    }

    @Override
    public void cleanup() {
    }
}

