/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.executor.FixedThreadPoolExecutorServices;
import org.jboss.weld.executor.ProfilingExecutorServices;
import org.jboss.weld.executor.SingleThreadExecutorServices;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class ExecutorServicesFactory {
    private static final String CONFIGURATION_FILE = "org.jboss.weld.executor.properties";
    private static final String ENABLED = "enabled";
    private static final String DEBUG = "debug";
    private static final String THREAD_POOL_SIZE = "threadPoolSize";

    private ExecutorServicesFactory() {
    }

    public static ExecutorServices create(ResourceLoader loader) {
        URL configuration = loader.getResource(CONFIGURATION_FILE);
        if (configuration == null) {
            return ExecutorServicesFactory.createDefault();
        }
        return ExecutorServicesFactory.create(ExecutorServicesFactory.loadProperties(configuration));
    }

    public static ExecutorServices create(Properties properties) {
        if (properties.getProperty(ENABLED, "true").equalsIgnoreCase("false")) {
            return new SingleThreadExecutorServices();
        }
        ExecutorServices executor = null;
        executor = properties.containsKey(THREAD_POOL_SIZE) ? new FixedThreadPoolExecutorServices(ExecutorServicesFactory.parseThreadPoolSize(properties.getProperty(THREAD_POOL_SIZE))) : new FixedThreadPoolExecutorServices();
        if (properties.getProperty(DEBUG, "false").equalsIgnoreCase("true")) {
            executor = new ProfilingExecutorServices(executor);
        }
        return executor;
    }

    public static ExecutorServices createDefault() {
        return new FixedThreadPoolExecutorServices();
    }

    protected static int parseThreadPoolSize(String size) {
        try {
            return Integer.valueOf(size);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException(BootstrapMessage.INVALID_THREAD_POOL_SIZE, size);
        }
    }

    protected static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
        return properties;
    }
}

