/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationModel<T extends Annotation> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private final AnnotatedType<T> annotatedAnnotation;
    protected boolean valid;

    public AnnotationModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        this.annotatedAnnotation = enhancedAnnotatedAnnotation.slim();
        this.init(enhancedAnnotatedAnnotation);
    }

    protected void init(EnhancedAnnotation<T> annotatedAnnotation) {
        this.initType(annotatedAnnotation);
        this.initValid(annotatedAnnotation);
        this.check(annotatedAnnotation);
    }

    protected void initType(EnhancedAnnotation<T> annotatedAnnotation) {
        if (!Annotation.class.isAssignableFrom(this.getRawType())) {
            throw new DefinitionException(MetadataMessage.META_ANNOTATION_ON_WRONG_TYPE, this.getMetaAnnotationTypes(), this.getRawType());
        }
    }

    protected void initValid(EnhancedAnnotation<T> annotatedAnnotation) {
        this.valid = false;
        for (Class<Annotation> annotationType : this.getMetaAnnotationTypes()) {
            if (!annotatedAnnotation.isAnnotationPresent(annotationType)) continue;
            this.valid = true;
        }
    }

    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        if (this.valid && (!annotatedAnnotation.isAnnotationPresent(Retention.class) || annotatedAnnotation.isAnnotationPresent(Retention.class) && !annotatedAnnotation.getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME))) {
            this.valid = false;
            log.debug(ReflectionMessage.MISSING_RETENTION, annotatedAnnotation);
        }
    }

    public Class<T> getRawType() {
        return this.annotatedAnnotation.getJavaClass();
    }

    protected abstract Set<Class<? extends Annotation>> getMetaAnnotationTypes();

    public boolean isValid() {
        return this.valid;
    }

    public AnnotatedType<T> getAnnotatedAnnotation() {
        return this.annotatedAnnotation;
    }

    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " annotation model for " + this.getRawType();
    }
}

