/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.util.collections.Arrays2;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Collections.singleton(Stereotype.class);
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private boolean alternative;
    private Annotation defaultScopeType;
    private boolean beanNameDefaulted;
    private Set<Annotation> interceptorBindings;
    private Set<Annotation> inheritedSterotypes;
    private Set<Annotation> metaAnnotations;

    public StereotypeModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
    }

    @Override
    protected void init(EnhancedAnnotation<T> annotatedAnnotation) {
        super.init(annotatedAnnotation);
        this.initAlternative(annotatedAnnotation);
        this.initDefaultScopeType(annotatedAnnotation);
        this.initBeanNameDefaulted(annotatedAnnotation);
        this.initInterceptorBindings(annotatedAnnotation);
        this.initInheritedStereotypes(annotatedAnnotation);
        this.checkBindings(annotatedAnnotation);
        this.metaAnnotations = annotatedAnnotation.getAnnotations();
    }

    private void checkBindings(EnhancedAnnotation<T> annotatedAnnotation) {
        Set<Annotation> bindings = annotatedAnnotation.getMetaAnnotations(Qualifier.class);
        if (bindings.size() > 0) {
            for (Annotation annotation : bindings) {
                if (annotation.annotationType().equals(Named.class)) continue;
                throw new DefinitionException(MetadataMessage.QUALIFIER_ON_STEREOTYPE, annotatedAnnotation);
            }
        }
    }

    private void initInterceptorBindings(EnhancedAnnotation<T> annotatedAnnotation) {
        this.interceptorBindings = annotatedAnnotation.getMetaAnnotations(InterceptorBinding.class);
    }

    private void initInheritedStereotypes(EnhancedAnnotation<T> annotatedAnnotation) {
        this.inheritedSterotypes = annotatedAnnotation.getMetaAnnotations(Stereotype.class);
    }

    private void initBeanNameDefaulted(EnhancedAnnotation<T> annotatedAnnotation) {
        if (annotatedAnnotation.isAnnotationPresent(Named.class)) {
            if (!"".equals(annotatedAnnotation.getAnnotation(Named.class).value())) {
                throw new DefinitionException(MetadataMessage.VALUE_ON_NAMED_STEREOTYPE, annotatedAnnotation);
            }
            this.beanNameDefaulted = true;
        }
    }

    private void initDefaultScopeType(EnhancedAnnotation<T> annotatedAnnotation) {
        HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
        scopeTypes.addAll(annotatedAnnotation.getMetaAnnotations(Scope.class));
        scopeTypes.addAll(annotatedAnnotation.getMetaAnnotations(NormalScope.class));
        if (scopeTypes.size() > 1) {
            throw new DefinitionException(MetadataMessage.MULTIPLE_SCOPES, annotatedAnnotation);
        }
        if (scopeTypes.size() == 1) {
            this.defaultScopeType = (Annotation)scopeTypes.iterator().next();
        }
    }

    private void initAlternative(EnhancedAnnotation<T> annotatedAnnotation) {
        if (annotatedAnnotation.isAnnotationPresent(Alternative.class)) {
            this.alternative = true;
        }
    }

    @Override
    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        super.check(annotatedAnnotation);
        if (this.isValid()) {
            if (!annotatedAnnotation.isAnnotationPresent(Target.class)) {
                log.debug(ReflectionMessage.MISSING_TARGET, annotatedAnnotation);
            } else if (!(Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE}) || Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.TYPE}) || Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD}) || Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.FIELD}) || Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.TYPE}))) {
                log.debug(ReflectionMessage.MISSING_TARGET_METHOD_FIELD_TYPE_PARAMETER_OR_TARGET_METHOD_TYPE_OR_TARGET_METHOD_OR_TARGET_TYPE_OR_TARGET_FIELD, annotatedAnnotation);
            }
        }
    }

    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public Set<Annotation> getInheritedSterotypes() {
        return this.inheritedSterotypes;
    }

    public Set<Annotation> getMetaAnnotations() {
        return this.metaAnnotations;
    }
}

