/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<AnnotatedMethod<?>, Object> values;
    private final int hashCode;

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Set<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return Collections.emptySet();
        }
        MetaAnnotationStore store = beanManager.getServices().get(MetaAnnotationStore.class);
        ArraySet<QualifierInstance> ret = new ArraySet<QualifierInstance>();
        for (Annotation a : annotations) {
            ret.add(new QualifierInstance(a, store));
        }
        return WeldCollections.immutableSet(ret);
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.qualifiers(beanManager, bean.getQualifiers());
    }

    public QualifierInstance(Annotation instance, MetaAnnotationStore store) {
        this(instance, instance.annotationType(), store);
    }

    private QualifierInstance(Annotation instance, Class<? extends Annotation> annotationClass, MetaAnnotationStore store) {
        this(annotationClass, QualifierInstance.createValues(instance, annotationClass, store));
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass, Map<AnnotatedMethod<?>, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = 31 * annotationClass.hashCode() + ((Object)values).hashCode();
    }

    private static Map<AnnotatedMethod<?>, Object> createValues(Annotation instance, Class<? extends Annotation> annotationClass, MetaAnnotationStore store) {
        HashMap values = new HashMap();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                values.put(method, RuntimeAnnotatedMembers.invokeMethod(method, instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        return WeldCollections.immutableMap(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return ((Object)this.values).equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance{annotationClass=" + this.annotationClass + ", values=" + this.values + ", hashCode=" + this.hashCode + '}';
    }
}

