/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Named;
import javax.inject.Provider;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.literal.NewLiteral;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.logging.messages.ResolutionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableBuilder {
    private static final Class<?>[] FACADE_TYPES = new Class[]{Event.class, Instance.class, Provider.class};
    private static final Class<?>[] METADATA_TYPES = new Class[]{Interceptor.class, Decorator.class, Bean.class};
    private static final Set<QualifierInstance> ANY_SINGLETON = Collections.singleton(QualifierInstance.ANY);
    protected Class<?> rawType;
    protected final Set<Type> types;
    protected final Set<Annotation> qualifiers;
    protected final Set<QualifierInstance> qualifierInstances;
    protected final Map<Class<? extends Annotation>, Annotation> mappedQualifiers;
    protected Bean<?> declaringBean;
    private final BeanManagerImpl beanManager;

    public ResolvableBuilder(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.types = new HashSet<Type>();
        this.qualifiers = new HashSet<Annotation>();
        this.mappedQualifiers = new HashMap<Class<? extends Annotation>, Annotation>();
        this.qualifierInstances = new HashSet<QualifierInstance>();
    }

    public ResolvableBuilder(Type type, BeanManagerImpl beanManager) {
        this(beanManager);
        if (type != null) {
            this.rawType = Reflections.getRawType(type);
            if (this.rawType == null || type instanceof TypeVariable) {
                throw new IllegalArgumentException(ResolutionMessage.CANNOT_EXTRACT_RAW_TYPE, type);
            }
            this.types.add(type);
        }
    }

    public ResolvableBuilder(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        this(injectionPoint.getType(), manager);
        this.addQualifiers(injectionPoint.getQualifiers());
        if (this.mappedQualifiers.containsKey(Named.class) && injectionPoint.getMember() instanceof Field) {
            MetaAnnotationStore store = this.beanManager.getServices().get(MetaAnnotationStore.class);
            Named named = (Named)this.mappedQualifiers.get(Named.class);
            QualifierInstance qualifierInstance = new QualifierInstance(named, store);
            if (named.value().equals("")) {
                this.qualifiers.remove(named);
                this.qualifierInstances.remove(qualifierInstance);
                named = new NamedLiteral(injectionPoint.getMember().getName());
                qualifierInstance = new QualifierInstance(named, store);
                this.qualifiers.add(named);
                this.qualifierInstances.add(qualifierInstance);
                this.mappedQualifiers.put(Named.class, named);
            }
        }
        this.setDeclaringBean(injectionPoint.getBean());
    }

    public ResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        this.declaringBean = declaringBean;
        return this;
    }

    public ResolvableBuilder addType(Type type) {
        this.types.add(type);
        return this;
    }

    public ResolvableBuilder addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public Resolvable create() {
        if (this.qualifiers.size() == 0) {
            MetaAnnotationStore store = this.beanManager.getServices().get(MetaAnnotationStore.class);
            this.qualifierInstances.add(new QualifierInstance(DefaultLiteral.INSTANCE, store));
        }
        for (Class<?> facadeType : FACADE_TYPES) {
            if (!Reflections.isAssignableFrom(facadeType, this.types)) continue;
            return this.createFacade(facadeType);
        }
        for (Class<?> metadataType : METADATA_TYPES) {
            if (!Reflections.isAssignableFrom(metadataType, this.types)) continue;
            return this.createMetadataProvider(metadataType);
        }
        return new ResolvableImpl(this.rawType, this.types, this.mappedQualifiers, this.declaringBean, this.qualifierInstances);
    }

    private Resolvable createFacade(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.mappedQualifiers, this.declaringBean, ANY_SINGLETON);
    }

    private Resolvable createMetadataProvider(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.mappedQualifiers, this.declaringBean, this.qualifierInstances);
    }

    public ResolvableBuilder addQualifier(Annotation qualifier) {
        MetaAnnotationStore store = this.beanManager.getServices().get(MetaAnnotationStore.class);
        QualifierInstance qualifierInstance = new QualifierInstance(qualifier, store);
        Class<? extends Annotation> annotationType = qualifierInstance.getAnnotationClass();
        if (annotationType.equals(New.class)) {
            New newQualifier = (New)New.class.cast(qualifier);
            if (newQualifier.value().equals(New.class) && this.rawType == null) {
                throw new IllegalStateException("Cannot transform @New when there is no known raw type");
            }
            if (newQualifier.value().equals(New.class)) {
                qualifier = new NewLiteral(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Class<?> value() {
                        return ResolvableBuilder.this.rawType;
                    }
                };
                qualifierInstance = new QualifierInstance(qualifier, store);
            }
        }
        this.checkQualifier(qualifier, qualifierInstance, annotationType);
        this.qualifiers.add(qualifier);
        this.qualifierInstances.add(qualifierInstance);
        this.mappedQualifiers.put(annotationType, qualifier);
        return this;
    }

    public ResolvableBuilder addQualifierIfAbsent(Annotation qualifier) {
        if (!this.qualifiers.contains(qualifier)) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Collection<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    protected void checkQualifier(Annotation qualifier, QualifierInstance qualifierInstance, Class<? extends Annotation> annotationType) {
        if (!this.beanManager.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotationType).isValid()) {
            throw new IllegalArgumentException(BeanManagerMessage.INVALID_QUALIFIER, qualifier);
        }
        if (this.qualifierInstances.contains(qualifierInstance)) {
            throw new IllegalArgumentException(BeanManagerMessage.DUPLICATE_QUALIFIERS, this.qualifiers);
        }
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ResolvableImpl
    implements Resolvable {
        private final Set<QualifierInstance> qualifierInstances;
        private final Map<Class<? extends Annotation>, Annotation> mappedQualifiers;
        private final Set<Type> typeClosure;
        private final Class<?> rawType;
        private final Bean<?> declaringBean;

        protected ResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Map<Class<? extends Annotation>, Annotation> mappedQualifiers, Bean<?> declaringBean, Set<QualifierInstance> qualifierInstances) {
            this.mappedQualifiers = mappedQualifiers;
            this.typeClosure = typeClosure;
            this.rawType = rawType;
            this.declaringBean = declaringBean;
            this.qualifierInstances = qualifierInstances;
        }

        @Override
        public Set<QualifierInstance> getQualifiers() {
            return this.qualifierInstances;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.mappedQualifiers.containsKey(annotationType);
        }

        @Override
        public Set<Type> getTypes() {
            return this.typeClosure;
        }

        @Override
        public boolean isAssignableTo(Class<?> clazz) {
            return Reflections.isAssignableFrom(clazz, this.typeClosure);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)Reflections.cast(this.mappedQualifiers.get(annotationType)));
        }

        @Override
        public Class<?> getJavaClass() {
            return this.rawType;
        }

        @Override
        public Bean<?> getDeclaringBean() {
            return this.declaringBean;
        }

        public String toString() {
            return "Types: " + this.getTypes() + "; Bindings: " + this.getQualifiers();
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + ((Object)this.getTypes()).hashCode();
            result = 31 * result + ((Object)this.qualifierInstances).hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof ResolvableImpl) {
                ResolvableImpl r = (ResolvableImpl)o;
                return ((Object)this.getTypes()).equals(r.getTypes()) && ((Object)this.qualifierInstances).equals(r.qualifierInstances);
            }
            return false;
        }
    }
}

