/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotationImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements Service {
    private static Logger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private final ConcurrentMap<TypeHolder<?>, BackedAnnotatedType<?>> discoveredSlimAnnotatedTypes;
    private final ConcurrentMap<AnnotatedType<?>, UnbackedAnnotatedType<?>> externalSlimAnnotatedTypes;
    private final ConcurrentMap<String, UnbackedAnnotatedType<?>> externalSlimAnnotatedTypesById;
    private final ConcurrentMap<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> enhancedAnnotatedTypes;
    private final ConcurrentMap<Class<? extends Annotation>, EnhancedAnnotation<?>> annotations;
    private final TypeStore typeStore;
    private final SharedObjectCache cache;

    public static ClassTransformer instance(BeanManagerImpl manager) {
        return manager.getServices().get(ClassTransformer.class);
    }

    public ClassTransformer(TypeStore typeStore, SharedObjectCache cache) {
        MapMaker defaultMaker = new MapMaker();
        MapMaker weakValuesMaker = new MapMaker().weakValues();
        this.discoveredSlimAnnotatedTypes = weakValuesMaker.makeComputingMap(new TransformClassToSlimAnnotatedType());
        this.externalSlimAnnotatedTypes = weakValuesMaker.makeComputingMap(new TransformExternalAnnotatedTypeToSlimAnnotatedType());
        this.externalSlimAnnotatedTypesById = new ConcurrentHashMap();
        this.enhancedAnnotatedTypes = defaultMaker.makeComputingMap(new TransformSlimAnnotatedTypeToEnhancedAnnotatedType());
        this.annotations = defaultMaker.makeComputingMap(new TransformClassToWeldAnnotation());
        this.typeStore = typeStore;
        this.cache = cache;
    }

    public <T> BackedAnnotatedType<T> getAnnotatedType(Class<T> rawType, Type baseType) {
        try {
            return (BackedAnnotatedType)Reflections.cast(this.discoveredSlimAnnotatedTypes.get(new TypeHolder(rawType, baseType)));
        }
        catch (ComputationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoClassDefFoundError || cause instanceof TypeNotPresentException || cause instanceof ResourceLoadingException || cause instanceof LinkageError) {
                throw new ResourceLoadingException("Error loading class " + rawType.getName(), cause);
            }
            if (log.isTraceEnabled()) {
                log.trace("Error loading class '" + rawType.getName() + "' : " + cause);
            }
            throw e;
        }
    }

    public <T> BackedAnnotatedType<T> getAnnotatedType(Class<T> rawType) {
        return this.getAnnotatedType(rawType, rawType);
    }

    public <T> SlimAnnotatedType<T> getAnnotatedType(AnnotatedType<T> type) {
        if (type instanceof SlimAnnotatedType) {
            return (SlimAnnotatedType)Reflections.cast(type);
        }
        if (type instanceof EnhancedAnnotatedType) {
            return (SlimAnnotatedType)Reflections.cast(((EnhancedAnnotatedType)Reflections.cast(type)).slim());
        }
        return (SlimAnnotatedType)Reflections.cast(this.externalSlimAnnotatedTypes.get(type));
    }

    public UnbackedAnnotatedType<?> getUnbackedAnnotatedType(String id) {
        return (UnbackedAnnotatedType)this.externalSlimAnnotatedTypesById.get(id);
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType) {
        return this.getEnhancedAnnotatedType(this.getAnnotatedType(rawType));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, Type baseType) {
        return this.getEnhancedAnnotatedType(this.getAnnotatedType(rawType, baseType));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(AnnotatedType<T> annotatedType) {
        if (annotatedType instanceof EnhancedAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(annotatedType);
        }
        if (annotatedType instanceof SlimAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(this.enhancedAnnotatedTypes.get(annotatedType));
        }
        return (EnhancedAnnotatedType)Reflections.cast(this.enhancedAnnotatedTypes.get(this.getAnnotatedType(annotatedType)));
    }

    public <T extends Annotation> EnhancedAnnotation<T> getEnhancedAnnotation(Class<T> clazz) {
        return (EnhancedAnnotation)this.annotations.get(clazz);
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.annotations.remove(annotationClass);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    public SharedObjectCache getSharedObjectCache() {
        return this.cache;
    }

    public void cleanupAfterBoot() {
        this.enhancedAnnotatedTypes.clear();
        this.annotations.clear();
        for (BackedAnnotatedType annotatedType : this.discoveredSlimAnnotatedTypes.values()) {
            annotatedType.clear();
        }
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.discoveredSlimAnnotatedTypes.clear();
        this.externalSlimAnnotatedTypes.clear();
        this.externalSlimAnnotatedTypesById.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeHolder<T> {
        private final Class<T> rawType;
        private final Type baseType;

        private TypeHolder(Class<T> rawType, Type baseType) {
            this.rawType = rawType;
            this.baseType = baseType;
        }

        public Type getBaseType() {
            return this.baseType;
        }

        public Class<T> getRawType() {
            return this.rawType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return this.getBaseType().equals(that.getBaseType());
            }
            return false;
        }

        public int hashCode() {
            return this.getBaseType().hashCode();
        }

        public String toString() {
            return this.getBaseType().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformSlimAnnotatedTypeToEnhancedAnnotatedType
    implements Function<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> {
        private TransformSlimAnnotatedTypeToEnhancedAnnotatedType() {
        }

        @Override
        public EnhancedAnnotatedType<?> apply(SlimAnnotatedType<?> annotatedType) {
            return EnhancedAnnotatedTypeImpl.of(annotatedType, ClassTransformer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformExternalAnnotatedTypeToSlimAnnotatedType
    implements Function<AnnotatedType<?>, UnbackedAnnotatedType<?>> {
        private TransformExternalAnnotatedTypeToSlimAnnotatedType() {
        }

        @Override
        public UnbackedAnnotatedType<?> apply(AnnotatedType<?> input) {
            UnbackedAnnotatedType<?> type = UnbackedAnnotatedType.of(input);
            ClassTransformer.this.externalSlimAnnotatedTypesById.put(AnnotatedTypes.createTypeId(type), type);
            return type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformClassToSlimAnnotatedType
    implements Function<TypeHolder<?>, BackedAnnotatedType<?>> {
        private TransformClassToSlimAnnotatedType() {
        }

        @Override
        public BackedAnnotatedType<?> apply(TypeHolder<?> typeHolder) {
            return BackedAnnotatedType.of(typeHolder.getRawType(), typeHolder.getBaseType(), ClassTransformer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformClassToWeldAnnotation
    implements Function<Class<? extends Annotation>, EnhancedAnnotation<?>> {
        private TransformClassToWeldAnnotation() {
        }

        @Override
        public EnhancedAnnotation<?> apply(Class<? extends Annotation> from) {
            return EnhancedAnnotationImpl.create(ClassTransformer.this.getAnnotatedType(from), ClassTransformer.this);
        }
    }
}

