/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedMember;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedMemberIdentifier;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTransformer
implements Service {
    private final ClassTransformer transformer;
    private final ConcurrentMap<Member, AnnotatedMember<?>> backedMemberCache;
    private final BackedFieldLoader backedFieldLoader;
    private final BackedMethodLoader backedMethodLoader;
    private final BackedConstructorLoader backedConstructorLoader;
    private final ConcurrentMap<UnbackedMemberIdentifier<?>, UnbackedAnnotatedMember<?>> unbackedAnnotatedMembersById;
    private final ConcurrentMap<AnnotatedMember<?>, EnhancedAnnotatedMember<?, ?, ?>> enhancedMemberCache;
    private final EnhancedFieldLoader enhancedFieldLoader;
    private final EnhancedMethodLoader enhancedMethodLoader;
    private final EnhancedConstructorLoader enhancedConstructorLoader;

    public MemberTransformer(ClassTransformer transformer) {
        this.transformer = transformer;
        this.backedFieldLoader = new BackedFieldLoader();
        this.backedMethodLoader = new BackedMethodLoader();
        this.backedConstructorLoader = new BackedConstructorLoader();
        this.backedMemberCache = new MapMaker().makeComputingMap(new BackedMemberLoaderFunction());
        this.unbackedAnnotatedMembersById = new MapMaker().makeComputingMap(new UnbackedMemberById());
        this.enhancedFieldLoader = new EnhancedFieldLoader();
        this.enhancedMethodLoader = new EnhancedMethodLoader();
        this.enhancedConstructorLoader = new EnhancedConstructorLoader();
        this.enhancedMemberCache = new MapMaker().makeComputingMap(new EnhancedMemberLoaderFunction());
    }

    public AnnotatedMember<?> loadBackedMember(Member member) {
        return (AnnotatedMember)Reflections.cast(this.backedMemberCache.get(member));
    }

    public <X> UnbackedAnnotatedMember<X> getUnbackedMember(UnbackedMemberIdentifier<X> identifier) {
        return (UnbackedAnnotatedMember)Reflections.cast(this.unbackedAnnotatedMembersById.get(identifier));
    }

    public <X, A extends EnhancedAnnotatedMember<?, X, ? extends Member>> A loadEnhancedMember(AnnotatedMember<X> member) {
        if (member instanceof EnhancedAnnotatedMember) {
            return (A)((EnhancedAnnotatedMember)Reflections.cast(member));
        }
        return (A)((EnhancedAnnotatedMember)Reflections.cast(this.enhancedMemberCache.get(member)));
    }

    public <X> EnhancedAnnotatedParameter<?, X> load(AnnotatedParameter<X> parameter) {
        if (parameter instanceof EnhancedAnnotatedParameter) {
            return (EnhancedAnnotatedParameter)Reflections.cast(parameter);
        }
        EnhancedAnnotatedCallable callable = (EnhancedAnnotatedCallable)this.loadEnhancedMember(parameter.getDeclaringCallable());
        return callable.getEnhancedParameters().get(parameter.getPosition());
    }

    public void cleanupAfterBoot() {
        this.enhancedMemberCache.clear();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.backedMemberCache.clear();
        this.unbackedAnnotatedMembersById.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnhancedConstructorLoader
    extends AbstractEnhancedMemberLoader<AnnotatedConstructor<?>, EnhancedAnnotatedConstructor<?>> {
        private EnhancedConstructorLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedConstructor<?> member1, AnnotatedConstructor<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedConstructor<?>> getMembersOfDeclaringType(AnnotatedConstructor<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.getEnhancedAnnotatedType(source.getDeclaringType()).getEnhancedConstructors());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnhancedMethodLoader
    extends AbstractEnhancedMemberLoader<AnnotatedMethod<?>, EnhancedAnnotatedMethod<?, ?>> {
        private EnhancedMethodLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedMethod<?, ?> member1, AnnotatedMethod<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedMethod<?, ?>> getMembersOfDeclaringType(AnnotatedMethod<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.getEnhancedAnnotatedType(source.getDeclaringType()).getDeclaredEnhancedMethods());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnhancedFieldLoader
    extends AbstractEnhancedMemberLoader<AnnotatedField<?>, EnhancedAnnotatedField<?, ?>> {
        private EnhancedFieldLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedField<?, ?> member1, AnnotatedField<?> member2) {
            return AnnotatedTypes.compareAnnotatedField(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedField<?, ?>> getMembersOfDeclaringType(AnnotatedField<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.getEnhancedAnnotatedType(source.getDeclaringType()).getDeclaredEnhancedFields());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractEnhancedMemberLoader<A extends AnnotatedMember<?>, W extends EnhancedAnnotatedMember<?, ?, ?>> {
        private AbstractEnhancedMemberLoader() {
        }

        public W load(A source) {
            return this.findMatching(this.getMembersOfDeclaringType(source), source);
        }

        public W findMatching(Collection<W> members, A source) {
            for (EnhancedAnnotatedMember member : members) {
                if (!this.equals(member, source)) continue;
                return (W)member;
            }
            throw new IllegalStateException(BeanMessage.UNABLE_TO_LOAD_MEMBER, source);
        }

        public abstract boolean equals(W var1, A var2);

        public abstract Collection<W> getMembersOfDeclaringType(A var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnhancedMemberLoaderFunction
    implements Function<AnnotatedMember<?>, EnhancedAnnotatedMember<?, ?, ?>> {
        private EnhancedMemberLoaderFunction() {
        }

        @Override
        public EnhancedAnnotatedMember<?, ?, ?> apply(AnnotatedMember<?> from) {
            if (from instanceof AnnotatedField) {
                return MemberTransformer.this.enhancedFieldLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            if (from instanceof AnnotatedMethod) {
                return MemberTransformer.this.enhancedMethodLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            if (from instanceof AnnotatedConstructor) {
                return MemberTransformer.this.enhancedConstructorLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_MEMBER, from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnbackedMemberById
    implements Function<UnbackedMemberIdentifier<?>, UnbackedAnnotatedMember<?>> {
        private UnbackedMemberById() {
        }

        @Override
        public UnbackedAnnotatedMember<?> apply(UnbackedMemberIdentifier<?> identifier) {
            return this.findMatchingMember(identifier.getType(), identifier.getMemberId());
        }

        private <T> UnbackedAnnotatedMember<T> findMatchingMember(UnbackedAnnotatedType<T> type, String id) {
            for (AnnotatedField<T> annotatedField : type.getFields()) {
                if (!id.equals(AnnotatedTypes.createFieldId(annotatedField))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedField);
            }
            for (AnnotatedMethod annotatedMethod : type.getMethods()) {
                if (!id.equals(AnnotatedTypes.createMethodId(annotatedMethod.getJavaMember(), annotatedMethod.getAnnotations(), annotatedMethod.getParameters()))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedMethod);
            }
            for (AnnotatedConstructor annotatedConstructor : type.getConstructors()) {
                if (!id.equals(AnnotatedTypes.createConstructorId(annotatedConstructor.getJavaMember(), annotatedConstructor.getAnnotations(), annotatedConstructor.getParameters()))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedConstructor);
            }
            throw new WeldException(BeanMessage.UNABLE_TO_LOAD_MEMBER, id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedConstructorLoader
    extends AbstractBackedMemberLoader<Constructor<?>, AnnotatedConstructor<?>> {
        private BackedConstructorLoader() {
        }

        @Override
        public Collection<? extends AnnotatedConstructor<?>> getMembersOfDeclaringType(BackedAnnotatedType<?> type) {
            return type.getConstructors();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedMethodLoader
    extends AbstractBackedMemberLoader<Method, AnnotatedMethod<?>> {
        private BackedMethodLoader() {
        }

        @Override
        public Collection<? extends AnnotatedMethod<?>> getMembersOfDeclaringType(BackedAnnotatedType<?> type) {
            return type.getMethods();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedFieldLoader
    extends AbstractBackedMemberLoader<Field, AnnotatedField<?>> {
        private BackedFieldLoader() {
        }

        @Override
        public Collection<? extends AnnotatedField<?>> getMembersOfDeclaringType(BackedAnnotatedType<?> type) {
            return type.getFields();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBackedMemberLoader<M extends Member, A extends AnnotatedMember<?>> {
        private AbstractBackedMemberLoader() {
        }

        public A load(M member) {
            BackedAnnotatedType<?> type = MemberTransformer.this.transformer.getAnnotatedType(member.getDeclaringClass());
            return this.findMatching(this.getMembersOfDeclaringType(type), member);
        }

        public <X> A findMatching(Collection<? extends A> members, M member) {
            for (AnnotatedMember annotatedMember : members) {
                if (!member.equals(annotatedMember.getJavaMember())) continue;
                return (A)annotatedMember;
            }
            throw new IllegalStateException(BeanMessage.UNABLE_TO_LOAD_MEMBER, member);
        }

        public abstract Collection<? extends A> getMembersOfDeclaringType(BackedAnnotatedType<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedMemberLoaderFunction
    implements Function<Member, AnnotatedMember<?>> {
        private BackedMemberLoaderFunction() {
        }

        @Override
        public AnnotatedMember<?> apply(Member member) {
            if (member instanceof Field) {
                return MemberTransformer.this.backedFieldLoader.load((Member)Reflections.cast(member));
            }
            if (member instanceof Method) {
                return MemberTransformer.this.backedMethodLoader.load((Member)Reflections.cast(member));
            }
            if (member instanceof Constructor) {
                return MemberTransformer.this.backedConstructorLoader.load((Member)Reflections.cast(member));
            }
            throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_MEMBER, member);
        }
    }
}

