/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Constructor;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorHolder<X>
extends AbstractSerializableHolder<Constructor<X>> {
    private static final long serialVersionUID = -6439218442811003152L;
    private final Class<X> declaringClass;
    private final Class<?>[] parameterTypes;

    public ConstructorHolder(Constructor<X> constructor) {
        super(constructor);
        this.declaringClass = constructor.getDeclaringClass();
        this.parameterTypes = constructor.getParameterTypes();
    }

    @Override
    protected Constructor<X> initialize() {
        try {
            return this.declaringClass.getConstructor(this.parameterTypes);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.UNABLE_TO_GET_CONSTRUCTOR_ON_DESERIALIZATION, (Throwable)e, this.declaringClass, this.parameterTypes);
        }
    }
}

