/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weld<T>
extends CDI<T> {
    private final ConcurrentMap<String, BeanManagerImpl> beanManagers = new MapMaker().weakValues().makeComputingMap(new ClassNameToBeanManager());
    private final Set<String> subclassNames;

    public Weld() {
        HashSet<String> names = new HashSet<String>();
        for (Class<?> clazz = this.getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        this.subclassNames = Collections.unmodifiableSet(names);
    }

    protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
        throw new IllegalStateException(BeanManagerMessage.UNSATISFIED_BEAN_MANAGER, callerClassName);
    }

    protected BeanManagerImpl ambiguousBeanManager(String callerClassName, Set<BeanManagerImpl> managers) {
        throw new IllegalStateException(BeanManagerMessage.AMBIGUOUS_BEAN_MANAGER, callerClassName);
    }

    @Override
    public BeanManagerImpl getBeanManager() {
        ContainerState state = Container.instance().getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw new IllegalStateException(BeanManagerMessage.BEAN_MANAGER_NOT_AVAILABLE, new Object[0]);
        }
        return (BeanManagerImpl)this.beanManagers.get(this.getCallingClassName());
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.subclassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw new IllegalStateException(BeanManagerMessage.UNABLE_TO_IDENTIFY_BEAN_MANAGER, new Object[0]);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getInstance().iterator();
    }

    @Override
    public T get() {
        return this.getInstance().get();
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        return this.getInstance().select(qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public boolean isUnsatisfied() {
        return this.getInstance().isUnsatisfied();
    }

    @Override
    public boolean isAmbiguous() {
        return this.getInstance().isAmbiguous();
    }

    protected Instance<T> getInstance() {
        return (Instance)Reflections.cast(this.getBeanManager().instance());
    }

    public String toString() {
        return "Weld";
    }

    public void cleanup() {
        this.beanManagers.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassNameToBeanManager
    implements Function<String, BeanManagerImpl> {
        private ClassNameToBeanManager() {
        }

        @Override
        public BeanManagerImpl apply(String callerClassName) {
            if (callerClassName == null) {
                throw new IllegalStateException(BeanManagerMessage.UNABLE_TO_IDENTIFY_BEAN_MANAGER, new Object[0]);
            }
            Container container = Container.instance();
            HashSet<BeanManagerImpl> managers = new HashSet<BeanManagerImpl>();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : container.beanDeploymentArchives().entrySet()) {
                for (String className : entry.getKey().getBeanClasses()) {
                    if (!className.equals(callerClassName)) continue;
                    managers.add(entry.getValue());
                }
            }
            if (managers.size() == 1) {
                return (BeanManagerImpl)managers.iterator().next();
            }
            if (managers.size() == 0) {
                return Weld.this.unsatisfiedBeanManager(callerClassName);
            }
            return Weld.this.ambiguousBeanManager(callerClassName, managers);
        }
    }
}

