/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedMethodImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.HashSetSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedAnnotationImpl<T extends Annotation>
extends EnhancedAnnotatedTypeImpl<T>
implements EnhancedAnnotation<T> {
    private final SetMultimap<Class<? extends Annotation>, EnhancedAnnotatedMethod<?, ?>> annotatedMembers;
    private final Class<T> clazz;
    private final Set<EnhancedAnnotatedMethod<?, ?>> members;

    public static <A extends Annotation> EnhancedAnnotation<A> create(SlimAnnotatedType<A> annotatedType, ClassTransformer classTransformer) {
        Class annotationType = annotatedType.getJavaClass();
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        annotationMap.putAll(EnhancedAnnotationImpl.buildAnnotationMap(annotationType.getAnnotations()));
        annotationMap.putAll(EnhancedAnnotationImpl.buildAnnotationMap(classTransformer.getTypeStore().get(annotationType)));
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        declaredAnnotationMap.putAll(EnhancedAnnotationImpl.buildAnnotationMap(annotationType.getDeclaredAnnotations()));
        declaredAnnotationMap.putAll(EnhancedAnnotationImpl.buildAnnotationMap(classTransformer.getTypeStore().get(annotationType)));
        return new EnhancedAnnotationImpl<A>(annotatedType, annotationMap, declaredAnnotationMap, classTransformer);
    }

    protected EnhancedAnnotationImpl(SlimAnnotatedType<T> annotatedType, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotatedType, annotationMap, declaredAnnotationMap, classTransformer);
        this.clazz = annotatedType.getJavaClass();
        this.members = new HashSet();
        this.annotatedMembers = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
            EnhancedAnnotatedMethodImpl enhancedAnnotatedMethod = EnhancedAnnotatedMethodImpl.of(annotatedMethod, this, classTransformer);
            this.members.add(enhancedAnnotatedMethod);
            for (Annotation annotation : enhancedAnnotatedMethod.getAnnotations()) {
                this.annotatedMembers.put(annotation.annotationType(), enhancedAnnotatedMethod);
            }
        }
    }

    @Override
    public Set<EnhancedAnnotatedMethod<?, ?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<EnhancedAnnotatedMethod<?, ?>> getMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMembers.get(annotationType));
    }

    @Override
    public String toString() {
        return this.getJavaClass().toString();
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }
}

