/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.util.annotated.ForwardingAnnotatedMethod;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokableAnnotatedMethod<T>
extends ForwardingAnnotatedMethod<T> {
    private final AnnotatedMethod<T> annotatedMethod;
    private volatile Map<Class<?>, Method> methods;

    public static <T> InvokableAnnotatedMethod<T> of(AnnotatedMethod<T> delegate) {
        return new InvokableAnnotatedMethod<T>(delegate);
    }

    public InvokableAnnotatedMethod(AnnotatedMethod<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
        this.methods = Collections.singletonMap(annotatedMethod.getJavaMember().getDeclaringClass(), annotatedMethod.getJavaMember());
    }

    public <X> X invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (X)SecureReflections.invoke(instance, this.annotatedMethod.getJavaMember(), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map<Class<?>, Method> methods = this.methods;
        Method method = methods.get(instance.getClass());
        if (method == null) {
            Method delegate = this.annotatedMethod.getJavaMember();
            method = SecureReflections.lookupMethod(instance.getClass(), delegate.getName(), delegate.getParameterTypes());
            InvokableAnnotatedMethod invokableAnnotatedMethod = this;
            synchronized (invokableAnnotatedMethod) {
                HashMap newMethods = new HashMap(methods);
                newMethods.put(instance.getClass(), method);
                this.methods = Collections.unmodifiableMap(newMethods);
            }
        }
        return (X)SecureReflections.invoke(instance, method, parameters);
    }

    @Override
    public AnnotatedMethod<T> delegate() {
        return this.annotatedMethod;
    }
}

