/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.ConstructorHolder;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedConstructor<X>
extends BackedAnnotatedMember<X>
implements AnnotatedConstructor<X>,
Serializable {
    private final Constructor<X> constructor;
    private final List<AnnotatedParameter<X>> parameters;

    public static <X> AnnotatedConstructor<X> of(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache cache) {
        return new BackedAnnotatedConstructor<X>(constructor, declaringType, cache);
    }

    public BackedAnnotatedConstructor(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache cache) {
        super(constructor.getDeclaringClass(), declaringType, cache);
        this.constructor = constructor;
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        if (parameterTypes.length == genericParameterTypes.length && genericParameterTypes.length == parameterAnnotations.length) {
            ArrayList parameters = new ArrayList(parameterTypes.length);
            int nesting = Reflections.getNesting(declaringType.getJavaClass());
            for (int i = 0; i < parameterTypes.length; ++i) {
                int position;
                Type parameterType;
                int gi = i - nesting;
                Class<?> clazz = parameterTypes[i];
                if (constructor.getGenericParameterTypes().length > gi && gi >= 0) {
                    parameterType = constructor.getGenericParameterTypes()[gi];
                    position = gi;
                } else {
                    parameterType = clazz;
                    position = i;
                }
                parameters.add(new BackedAnnotatedParameter(parameterType, parameterAnnotations[position], position, this, cache));
            }
            this.parameters = WeldCollections.immutableList(parameters);
        } else {
            this.parameters = Collections.emptyList();
        }
    }

    @Override
    public Constructor<X> getJavaMember() {
        return this.constructor;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.constructor.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return ImmutableSet.copyOf(this.constructor.getAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.constructor.isAnnotationPresent(annotationType);
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedConstructor other = (BackedAnnotatedConstructor)obj;
        return !(this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor));
    }

    public String toString() {
        return Formats.formatAnnotatedConstructor(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy<X>(this.constructor);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = -2726172060851333254L;
        private final ConstructorHolder<X> constructor;

        public SerializationProxy(Constructor<X> constructor) {
            this.constructor = new ConstructorHolder<X>(constructor);
        }

        private Object readResolve() {
            return Container.instance().services().get(MemberTransformer.class).loadBackedMember((Member)this.constructor.get());
        }
    }
}

