/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.MethodHolder;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedMethod<X>
extends BackedAnnotatedMember<X>
implements AnnotatedMethod<X>,
Serializable {
    private final Method method;
    private final List<AnnotatedParameter<X>> parameters;

    public static <X, Y extends X> AnnotatedMethod<X> of(Method method, BackedAnnotatedType<Y> declaringType, SharedObjectCache cache) {
        BackedAnnotatedType downcastDeclaringType = (BackedAnnotatedType)Reflections.cast(declaringType);
        return new BackedAnnotatedMethod<X>(method, downcastDeclaringType, cache);
    }

    public BackedAnnotatedMethod(Method method, BackedAnnotatedType<X> declaringType, SharedObjectCache cache) {
        super(method.getGenericReturnType(), declaringType, cache);
        this.method = method;
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        ArrayList parameters = new ArrayList(genericParameterTypes.length);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type parameterType = genericParameterTypes[i];
            parameters.add(BackedAnnotatedParameter.of(parameterType, parameterAnnotations[i], i, this, cache));
        }
        this.parameters = WeldCollections.immutableList(parameters);
    }

    @Override
    public Method getJavaMember() {
        return this.method;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.method.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return ImmutableSet.copyOf(this.method.getAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.method.isAnnotationPresent(annotationType);
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedMethod other = (BackedAnnotatedMethod)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        return Formats.formatAnnotatedMethod(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.method);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 8008578690970722095L;
        private final MethodHolder method;

        public SerializationProxy(Method method) {
            this.method = new MethodHolder(method);
        }

        private Object readResolve() {
            return Container.instance().services().get(MemberTransformer.class).loadBackedMember((Member)this.method.get());
        }
    }
}

