/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.unbacked;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotated;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedConstructor;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedField;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedMethod;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class UnbackedAnnotatedType<X>
extends UnbackedAnnotated
implements SlimAnnotatedType<X>,
Serializable {
    private final Class<X> javaClass;
    private final Set<AnnotatedConstructor<X>> constructors;
    private final Set<AnnotatedMethod<? super X>> methods;
    private final Set<AnnotatedField<? super X>> fields;

    public static <X> UnbackedAnnotatedType<X> of(AnnotatedType<X> originalType) {
        return new UnbackedAnnotatedType<X>(originalType.getBaseType(), originalType.getTypeClosure(), originalType.getAnnotations(), originalType.getJavaClass(), originalType.getConstructors(), originalType.getMethods(), originalType.getFields());
    }

    public UnbackedAnnotatedType(Type baseType, Set<Type> typeClosure, Set<Annotation> annotations, Class<X> javaClass, Set<AnnotatedConstructor<X>> originalConstructors, Set<AnnotatedMethod<? super X>> originalMethods, Set<AnnotatedField<? super X>> originalFields) {
        super(baseType, typeClosure, annotations);
        this.javaClass = javaClass;
        HashSet<AnnotatedConstructor<X>> constructors = new HashSet<AnnotatedConstructor<X>>(originalConstructors.size());
        for (AnnotatedConstructor<X> originalConstructor : originalConstructors) {
            constructors.add(UnbackedAnnotatedConstructor.of(originalConstructor, this));
        }
        this.constructors = WeldCollections.immutableSet(constructors);
        HashSet<AnnotatedMethod<X>> methods = new HashSet<AnnotatedMethod<X>>(originalMethods.size());
        for (AnnotatedMethod<X> annotatedMethod : originalMethods) {
            methods.add(UnbackedAnnotatedMethod.of(annotatedMethod, this));
        }
        this.methods = WeldCollections.immutableSet(methods);
        HashSet<AnnotatedField<X>> fields = new HashSet<AnnotatedField<X>>(originalFields.size());
        for (AnnotatedField<X> annotatedField : originalFields) {
            fields.add(UnbackedAnnotatedField.of(annotatedField, this));
        }
        this.fields = WeldCollections.immutableSet(fields);
    }

    @Override
    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.constructors;
    }

    @Override
    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<AnnotatedField<? super X>> getFields() {
        return this.fields;
    }

    public String toString() {
        return Formats.formatAnnotatedType(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = 402976292268601274L;
        private final String id;

        public SerializationProxy(UnbackedAnnotatedType<X> annotatedType) {
            this.id = AnnotatedTypes.createTypeId(annotatedType);
        }

        private Object readResolve() {
            return Container.instance().services().get(ClassTransformer.class).getUnbackedAnnotatedType(this.id);
        }
    }
}

