/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.reflection.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorMetadata<?> interceptorMetadata;
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        return new InterceptorImpl<T>(attributes, type, beanManager);
    }

    protected InterceptorImpl(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        super(attributes, type, Interceptor.class.getSimpleName() + "-" + type.getName(), beanManager);
        this.interceptorMetadata = beanManager.getInterceptorMetadataReader().getInterceptorMetadata(ClassMetadataInterceptorReference.of(WeldInterceptorClassMetadata.of(type)));
        this.serializable = type.isSerializable();
        this.interceptorBindingTypes = new HashSet<Annotation>(Interceptors.mergeBeanInterceptorBindings(beanManager, this.getEnhancedAnnotated(), this.getStereotypes()).values());
        if (this.interceptorBindingTypes.size() == 0) {
            throw new DeploymentException(BeanMessage.MISSING_BINDING_ON_INTERCEPTOR, type.getName());
        }
        if (Beans.findInterceptorBindingConflicts(beanManager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    public InterceptorMetadata<?> getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    @Override
    public Object intercept(javax.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        try {
            InterceptionType interceptionType = InterceptionType.valueOf(type.name());
            ArrayList<InterceptorInvocation> invocations = new ArrayList<InterceptorInvocation>();
            invocations.add(this.interceptorMetadata.getInterceptorInvocation(instance, this.interceptorMetadata, interceptionType));
            return new SimpleInterceptionChain(invocations, instance, ctx.getMethod()).invokeNextInterceptor(ctx);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WeldException(e);
        }
    }

    @Override
    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorMetadata.isEligible(InterceptionType.valueOf(type.name()));
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public String toString() {
        return "Interceptor [" + this.getBeanClass() + " intercepts " + Formats.formatAnnotations(this.getInterceptorBindings()) + "]";
    }
}

