/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.interceptor.WeldAnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.DefaultMethodMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.util.collections.WeldCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldInterceptorClassMetadata<T>
implements ClassMetadata<T>,
Serializable {
    private static final long serialVersionUID = -5087425231467781559L;
    private Class<T> clazz;
    private WeldInterceptorClassMetadata<?> superclass;
    private Collection<MethodMetadata> methodMetadatas;

    private WeldInterceptorClassMetadata(EnhancedAnnotatedType<T> weldClass) {
        this.clazz = weldClass.getJavaClass();
        ArrayList<MethodMetadata> methodMetadatas = new ArrayList<MethodMetadata>();
        for (EnhancedAnnotatedMethod<?, T> method : weldClass.getDeclaredEnhancedMethods()) {
            MethodMetadata methodMetadata = DefaultMethodMetadata.of(method, WeldAnnotatedMethodReader.getInstance());
            if (methodMetadata.getSupportedInterceptionTypes() == null || methodMetadata.getSupportedInterceptionTypes().size() == 0) continue;
            methodMetadatas.add(methodMetadata);
        }
        this.methodMetadatas = WeldCollections.immutableList(methodMetadatas);
        if (weldClass.getEnhancedSuperclass() != null) {
            this.superclass = WeldInterceptorClassMetadata.of(weldClass.getEnhancedSuperclass());
        }
    }

    public static <T> WeldInterceptorClassMetadata<T> of(EnhancedAnnotatedType<T> weldClass) {
        return new WeldInterceptorClassMetadata<T>(weldClass);
    }

    @Override
    public String getClassName() {
        return this.clazz.getName();
    }

    @Override
    public Iterable<MethodMetadata> getDeclaredMethods() {
        return this.methodMetadatas;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.clazz;
    }

    @Override
    public ClassMetadata<?> getSuperclass() {
        return this.superclass;
    }
}

