/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ProcessBeanAttributesImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanInjectionTarget;
import org.jboss.weld.bootstrap.events.ProcessManagedBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerFieldImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessSessionBeanImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanManagerImpl manager;
    private final ServiceRegistry services;
    private final E environment;

    public AbstractBeanDeployer(BeanManagerImpl manager, ServiceRegistry services, E environment) {
        this.manager = manager;
        this.services = services;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    protected void preloadContainerLifecycleEvent(Class<?> eventRawType, Type ... typeParameters) {
    }

    public AbstractBeanDeployer<E> deploySpecialized() {
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), decoratorImpl);
            this.manager.addDecorator(decoratorImpl);
            log.debug(BootstrapMessage.FOUND_DECORATOR, decoratorImpl);
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), interceptorImpl);
            this.manager.addInterceptor(interceptorImpl);
            log.debug(BootstrapMessage.FOUND_INTERCEPTOR, interceptorImpl);
        }
        return this;
    }

    public AbstractBeanDeployer<E> initializeBeans() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            bean.initialize((BeanDeployerEnvironment)this.getEnvironment());
        }
        return this;
    }

    public AbstractBeanDeployer<E> fireBeanEvents() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            this.fireBeanEvents(bean);
        }
        return this;
    }

    public void fireBeanEvents(RIBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            if (bean instanceof AbstractProducerBean) {
                ProcessProducerImpl.fire(this.manager, (AbstractProducerBean)Reflections.cast(bean));
            } else if (bean instanceof AbstractClassBean) {
                ProcessBeanInjectionTarget.fire(this.manager, (AbstractClassBean)bean);
            }
            if (bean instanceof ManagedBean) {
                ProcessManagedBeanImpl.fire(this.manager, (ManagedBean)bean);
            } else if (bean instanceof SessionBean) {
                ProcessSessionBeanImpl.fire(this.manager, (SessionBean)Reflections.cast(bean));
            } else if (bean instanceof ProducerField) {
                ProcessProducerFieldImpl.fire(this.manager, (ProducerField)bean);
            } else if (bean instanceof ProducerMethod) {
                ProcessProducerMethodImpl.fire(this.manager, (ProducerMethod)bean);
            } else {
                ProcessBeanImpl.fire(this.getManager(), bean);
            }
        }
    }

    public AbstractBeanDeployer<E> deployBeans() {
        this.manager.addBeans(((BeanDeployerEnvironment)this.getEnvironment()).getBeans());
        return this;
    }

    public AbstractBeanDeployer<E> initializeObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            observerInitializer.initialize();
        }
        return this;
    }

    public AbstractBeanDeployer<E> deployObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            log.debug(BootstrapMessage.FOUND_OBSERVER_METHOD, observerInitializer.getObserver());
            ProcessObserverMethodImpl.fire(this.manager, observerInitializer.getObserver());
            this.manager.addObserver(observerInitializer.getObserver());
        }
        return this;
    }

    protected <T> void createObserversProducersDisposers(AbstractClassBean<T> bean) {
        if (bean instanceof ManagedBean || bean instanceof SessionBean) {
            this.createDisposalMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerFields((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            if (this.manager.isBeanEnabled(bean)) {
                this.createObserverMethods((RIBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            }
        }
    }

    protected <X> DisposalMethod<X, ?> resolveDisposalMethod(BeanAttributes<?> attributes, AbstractClassBean<X> declaringBean) {
        Set<DisposalMethod<X, ?>> disposalBeans = ((BeanDeployerEnvironment)this.environment).resolveDisposalBeans(attributes.getTypes(), attributes.getQualifiers(), declaringBean);
        if (disposalBeans.size() == 1) {
            return disposalBeans.iterator().next();
        }
        if (disposalBeans.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSAL_METHODS, this, disposalBeans);
        }
        return null;
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedMethod<?, X> method : annotatedClass.getDeclaredEnhancedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedMethod<?, X> method : annotatedClass.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethod<X, ?> disposalBean = DisposalMethod.of(this.manager, method, declaringBean);
            ((BeanDeployerEnvironment)this.getEnvironment()).addDisposesMethod(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> annotatedMethod) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(annotatedMethod, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        ProducerMethod<X, T> bean = ProducerMethod.of(attributes, annotatedMethod, declaringBean, disposalMethod, this.manager, this.services);
        this.preloadContainerLifecycleEvent(ProcessBeanAttributes.class, bean.getType());
        this.preloadContainerLifecycleEvent(ProcessProducerMethod.class, annotatedMethod.getBaseType(), bean.getBeanClass());
        this.preloadContainerLifecycleEvent(ProcessProducer.class, bean.getBeanClass(), annotatedMethod.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerMethod(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, EnhancedAnnotatedField<T, ? super X> field) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(field, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        ProducerField bean = this.isEEResourceProducerField(field) ? EEResourceProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services) : ProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services);
        this.preloadContainerLifecycleEvent(ProcessBeanAttributes.class, bean.getType());
        this.preloadContainerLifecycleEvent(ProcessProducerField.class, field.getBaseType(), bean.getBeanClass());
        this.preloadContainerLifecycleEvent(ProcessProducer.class, bean.getBeanClass(), field.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerField(bean);
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedField<?, X> field : annotatedClass.getDeclaredEnhancedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, EnhancedAnnotatedType<? super X> annotatedClass) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : Beans.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, enhancedAnnotatedMethod);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> method) {
        ObserverMethodImpl<T, X> observer = ObserverFactory.create(method, declaringBean, this.manager);
        ObserverInitializationContext<T, ? super X> observerInitializer = ObserverInitializationContext.of(observer, method);
        this.preloadContainerLifecycleEvent(ProcessObserverMethod.class, observer.getObservedType(), declaringBean.getBeanClass());
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserverMethod(observerInitializer);
    }

    protected <T> ManagedBean<T> createManagedBean(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        ManagedBean bean = ManagedBean.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(bean);
        return bean;
    }

    protected <T> void createNewManagedBean(EnhancedAnnotatedType<T> annotatedClass) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(NewManagedBean.of(BeanAttributesFactory.forNewManagedBean(annotatedClass, this.manager), annotatedClass, this.manager));
    }

    protected <T> void createDecorator(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        DecoratorImpl bean = DecoratorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addDecorator(bean);
    }

    protected <T> void createInterceptor(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        InterceptorImpl bean = InterceptorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addInterceptor(bean);
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor) {
        return this.createSessionBean(descriptor, this.services.get(ClassTransformer.class).getEnhancedAnnotatedType(descriptor.getBeanClass()));
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor, EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forSessionBean(weldClass, descriptor, this.getManager());
        SessionBean<T> bean = SessionBean.of(attributes, descriptor, this.manager, weldClass);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(bean);
        return bean;
    }

    protected <T> void createNewSessionBean(InternalEjbDescriptor<T> ejbDescriptor, BeanAttributes<?> originalAttributes, Class<?> javaClass) {
        BeanAttributes attributes = (BeanAttributes)Reflections.cast(BeanAttributesFactory.forNewSessionBean(originalAttributes, javaClass));
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(NewSessionBean.of(attributes, ejbDescriptor, this.manager));
    }

    protected boolean isEEResourceProducerField(EnhancedAnnotatedField<?, ?> field) {
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = this.manager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    public E getEnvironment() {
        return this.environment;
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        this.preloadContainerLifecycleEvent(ProcessBean.class, bean.getBeanClass());
        ((BeanDeployerEnvironment)this.getEnvironment()).addBuiltInBean(bean);
    }

    protected <T, S> boolean fireProcessBeanAttributes(AbstractBean<T, S> bean) {
        if (!this.manager.getServices().get(SpecializationAndEnablementRegistry.class).isCandidateForLifecycleEvent(bean)) {
            return false;
        }
        ProcessBeanAttributesImpl event = ProcessBeanAttributesImpl.fire(this.getManager(), bean, bean.getAnnotated(), bean.getType());
        if (event.isVeto()) {
            return true;
        }
        if (event.isDirty()) {
            bean.setAttributes(ExternalBeanAttributesFactory.of(event.getBeanAttributes(), this.manager));
            bean.checkSpecialization();
        }
        return false;
    }
}

