/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.spi.Context;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.BeanMetadataBean;
import org.jboss.weld.bean.builtin.ContextBean;
import org.jboss.weld.bean.builtin.ConversationBean;
import org.jboss.weld.bean.builtin.DecoratedBeanMetadataBean;
import org.jboss.weld.bean.builtin.DecoratorMetadataBean;
import org.jboss.weld.bean.builtin.EventBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.bean.builtin.InstanceBean;
import org.jboss.weld.bean.builtin.InterceptedBeanMetadataBean;
import org.jboss.weld.bean.builtin.InterceptorMetadataBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorFactoryBean;
import org.jboss.weld.bean.builtin.ee.HttpServletRequestBean;
import org.jboss.weld.bean.builtin.ee.HttpSessionBean;
import org.jboss.weld.bean.builtin.ee.PrincipalBean;
import org.jboss.weld.bean.builtin.ee.ServletContextBean;
import org.jboss.weld.bean.builtin.ee.UserTransactionBean;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.ConcurrentBeanDeployer;
import org.jboss.weld.bootstrap.ConcurrentValidator;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.EnabledBuilder;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.enums.EnumService;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.jsf.JsfApiAbstraction;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.FilterPredicate;
import org.jboss.weld.metadata.ScanningPredicate;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.JtaApiAbstraction;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.instantiation.DefaultInstantiatorFactory;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployment {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final BeanDeployer beanDeployer;
    private final Collection<ContextHolder<? extends Context>> contexts;
    private final EnabledBuilder enabledBuilder;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Collection<ContextHolder<? extends Context>> contexts) {
        InstantiatorFactory factory;
        this.beanDeploymentArchive = beanDeploymentArchive;
        EjbDescriptors ejbDescriptors = new EjbDescriptors();
        ServiceRegistry registry = beanDeploymentArchive.getServices();
        registry.add(EjbDescriptors.class, ejbDescriptors);
        ResourceLoader resourceLoader = registry.get(ResourceLoader.class);
        if (resourceLoader == null) {
            resourceLoader = DefaultResourceLoader.INSTANCE;
            registry.add(ResourceLoader.class, resourceLoader);
        }
        if ((factory = registry.get(InstantiatorFactory.class)) == null) {
            registry.add(InstantiatorFactory.class, new DefaultInstantiatorFactory());
        }
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll(deploymentServices.entrySet());
        services.addAll(registry.entrySet());
        services.add(EJBApiAbstraction.class, new EJBApiAbstraction(resourceLoader));
        services.add(JsfApiAbstraction.class, new JsfApiAbstraction(resourceLoader));
        services.add(PersistenceApiAbstraction.class, new PersistenceApiAbstraction(resourceLoader));
        services.add(WSApiAbstraction.class, new WSApiAbstraction(resourceLoader));
        services.add(JtaApiAbstraction.class, new JtaApiAbstraction(resourceLoader));
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, beanDeploymentArchive.getId(), services);
        this.enabledBuilder = EnabledBuilder.of(beanDeploymentArchive.getBeansXml(), resourceLoader);
        services.add(InjectionTargetService.class, new InjectionTargetService(this.beanManager));
        services.add(EnumService.class, new EnumService(this.beanManager));
        if (this.beanManager.getServices().contains(EjbServices.class)) {
            ejbDescriptors.addAll(beanDeploymentArchive.getEjbs());
        }
        this.beanDeployer = services.get(Validator.class) instanceof ConcurrentValidator ? new ConcurrentBeanDeployer(this.beanManager, ejbDescriptors, deploymentServices) : new BeanDeployer(this.beanManager, ejbDescriptors, deploymentServices);
        this.beanManager.addBean(new BeanManagerBean(this.beanManager));
        this.contexts = contexts;
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    protected Iterable<String> loadClasses() {
        Collection<String> classNames;
        Function<Metadata<Filter>, Predicate<String>> filterToPredicateFunction = new Function<Metadata<Filter>, Predicate<String>>(){
            ResourceLoader resourceLoader;
            {
                this.resourceLoader = BeanDeployment.this.getBeanManager().getServices().get(ResourceLoader.class);
            }

            @Override
            public Predicate<String> apply(Metadata<Filter> from) {
                return new FilterPredicate(from, this.resourceLoader);
            }
        };
        if (this.getBeanDeploymentArchive().getBeansXml() != null && this.getBeanDeploymentArchive().getBeansXml().getScanning() != null) {
            Collection<Object> includeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() : Collections.emptyList();
            Collection<Object> excludeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() : Collections.emptyList();
            ArrayList includes = new ArrayList(Collections2.transform(includeFilters, filterToPredicateFunction));
            ArrayList excludes = new ArrayList(Collections2.transform(excludeFilters, filterToPredicateFunction));
            ScanningPredicate filters = new ScanningPredicate(includes, excludes);
            classNames = Collections2.filter(this.beanDeploymentArchive.getBeanClasses(), filters);
        } else {
            classNames = this.beanDeploymentArchive.getBeanClasses();
        }
        return classNames;
    }

    public void createClasses() {
        this.beanDeployer.addClasses(this.loadClasses());
    }

    public void createEnabled() {
        this.beanManager.setEnabled(this.enabledBuilder.create());
        this.enabledBuilder.clear();
        log.debug(BootstrapMessage.ENABLED_ALTERNATIVES, this.beanManager, this.beanManager.getEnabled().getAlternativeClasses(), this.beanManager.getEnabled().getAlternativeStereotypes());
        log.debug(BootstrapMessage.ENABLED_DECORATORS, this.beanManager, this.beanManager.getEnabled().getDecorators());
        log.debug(BootstrapMessage.ENABLED_INTERCEPTORS, this.beanManager, this.beanManager.getEnabled().getInterceptors());
    }

    public void createBeans(Environment environment) {
        this.beanDeployer.processAnnotatedTypes();
        this.beanDeployer.addBuiltInBean(new InjectionPointBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new EventBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InstanceBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new ConversationBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new BeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InterceptedBeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new DecoratedBeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InterceptorMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new DecoratorMetadataBean(this.beanManager));
        if (Reflections.isClassLoadable("javax.servlet.ServletContext", this.beanDeploymentArchive.getServices().get(ResourceLoader.class))) {
            HttpServletRequestBean httpServletRequestBean = new HttpServletRequestBean(this.beanManager);
            this.beanDeployer.addBuiltInBean(httpServletRequestBean);
            this.beanDeployer.addBuiltInBean(new HttpSessionBean(httpServletRequestBean, this.beanManager));
            this.beanDeployer.addBuiltInBean(new ServletContextBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(TransactionServices.class)) {
            this.beanDeployer.addBuiltInBean(new UserTransactionBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(SecurityServices.class)) {
            this.beanDeployer.addBuiltInBean(new PrincipalBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(ValidationServices.class)) {
            this.beanDeployer.addBuiltInBean(new DefaultValidatorBean(this.beanManager));
            this.beanDeployer.addBuiltInBean(new DefaultValidatorFactoryBean(this.beanManager));
        }
        for (ContextHolder<? extends Context> context : this.contexts) {
            this.beanDeployer.addBuiltInBean(ContextBean.of(context, this.beanManager));
        }
        this.beanDeployer.processEnums();
        this.beanDeployer.createClassBeans();
    }

    public void deploySpecialized(Environment environment) {
        this.beanDeployer.deploySpecialized();
    }

    public void deployBeans(Environment environment) {
        this.beanDeployer.deploy();
    }

    public void afterBeanDiscovery(Environment environment) {
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getBeans());
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getDecorators());
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getInterceptors());
    }

    public EnabledBuilder getEnabledBuilder() {
        return this.enabledBuilder;
    }
}

