/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.ContainerLifecycleEventPreloader;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.executor.IterativeWorkerTaskFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentBeanDeployer
extends BeanDeployer {
    private final ExecutorServices executor;
    private final ContainerLifecycleEventPreloader preloader;

    public ConcurrentBeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        super(manager, ejbDescriptors, services, BeanDeployerEnvironmentFactory.newConcurrentEnvironment(ejbDescriptors, manager));
        this.executor = services.get(ExecutorServices.class);
        this.preloader = services.get(ContainerLifecycleEventPreloader.class);
    }

    @Override
    protected void preloadContainerLifecycleEvent(Class<?> eventRawType, Type ... typeParameters) {
        if (this.preloader != null) {
            this.preloader.preloadContainerLifecycleEvent(this.getManager(), eventRawType, typeParameters);
        }
    }

    @Override
    public BeanDeployer addClasses(Iterable<String> c) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<String>(c){

            @Override
            protected void doWork(String className) {
                ConcurrentBeanDeployer.this.addClass(className);
            }
        });
        return this;
    }

    @Override
    public void createClassBeans() {
        final ConcurrentMap otherWeldClasses = Multimaps.newConcurrentSetMultimap();
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<AnnotatedType<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()){

            @Override
            protected void doWork(AnnotatedType<?> weldClass) {
                ConcurrentBeanDeployer.this.createClassBean(weldClass, otherWeldClasses);
            }
        });
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<InternalEjbDescriptor<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()){

            @Override
            protected void doWork(InternalEjbDescriptor<?> descriptor) {
                if (!((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment()).isVetoed(descriptor.getBeanClass()) && (descriptor.isSingleton() || descriptor.isStateful() || descriptor.isStateless())) {
                    if (otherWeldClasses.containsKey(descriptor.getBeanClass())) {
                        for (AnnotatedType annotatedType : (Set)otherWeldClasses.get(descriptor.getBeanClass())) {
                            EnhancedAnnotatedType weldClass = ConcurrentBeanDeployer.this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                            ConcurrentBeanDeployer.this.createSessionBean(descriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                        }
                    } else {
                        ConcurrentBeanDeployer.this.createSessionBean(descriptor);
                    }
                }
            }
        });
    }

    @Override
    public void createProducersAndObservers() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<AbstractClassBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()){

            @Override
            protected void doWork(AbstractClassBean<?> bean) {
                ConcurrentBeanDeployer.this.createObserversProducersDisposers(bean);
            }
        });
    }

    @Override
    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        this.executor.invokeAllAndCheckForExceptions(new AfterBeanDiscoveryInitializerFactory((Iterable<? extends Bean<?>>)beanList));
    }

    @Override
    public AbstractBeanDeployer<BeanDeployerEnvironment> initializeBeans() {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<RIBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getBeans()){

            @Override
            protected void doWork(RIBean<?> bean) {
                bean.initialize((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment());
            }
        });
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AfterBeanDiscoveryInitializerFactory
    extends IterativeWorkerTaskFactory<Bean<?>> {
        public AfterBeanDiscoveryInitializerFactory(Iterable<? extends Bean<?>> iterable) {
            super(iterable);
        }

        @Override
        protected void doWork(Bean<?> bean) {
            if (bean instanceof RIBean) {
                ((RIBean)bean).initializeAfterBeanDiscovery();
            }
        }
    }
}

