/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.TypeSafeObserverResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalObserverNotifierService
implements Service {
    private final Set<BeanManagerImpl> beanManagers = new CopyOnWriteArraySet<BeanManagerImpl>();
    private final ObserverNotifier globalObserverNotifier;

    public GlobalObserverNotifierService(ServiceRegistry services) {
        TypeSafeObserverResolver resolver = new TypeSafeObserverResolver(services.get(MetaAnnotationStore.class), GlobalObserverNotifierService.createGlobalObserverMethodIterable(this.beanManagers));
        this.globalObserverNotifier = ObserverNotifier.of(resolver, services);
    }

    private static Iterable<ObserverMethod<?>> createGlobalObserverMethodIterable(final Set<BeanManagerImpl> beanManagers) {
        return new Iterable<ObserverMethod<?>>(){

            @Override
            public Iterator<ObserverMethod<?>> iterator() {
                Iterator observerMethodIterators = Iterators.transform(beanManagers.iterator(), new BeanManagerToObserverMethodIterable());
                return Iterators.concat(observerMethodIterators);
            }
        };
    }

    public void registerBeanManager(BeanManagerImpl manager) {
        this.beanManagers.add(manager);
    }

    public ObserverNotifier getGlobalObserverNotifier() {
        return this.globalObserverNotifier;
    }

    @Override
    public void cleanup() {
        this.beanManagers.clear();
        this.globalObserverNotifier.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanManagerToObserverMethodIterable
    implements Function<BeanManagerImpl, Iterator<ObserverMethod<?>>> {
        private BeanManagerToObserverMethodIterable() {
        }

        @Override
        public Iterator<ObserverMethod<?>> apply(BeanManagerImpl manager) {
            return manager.getObservers().iterator();
        }
    }
}

