/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.TransactionalObserverNotifier;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverNotifier {
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;

    public static ObserverNotifier of(TypeSafeObserverResolver resolver, ServiceRegistry services) {
        if (services.contains(TransactionServices.class)) {
            return new TransactionalObserverNotifier(resolver, services);
        }
        return new ObserverNotifier(resolver, services);
    }

    protected ObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services) {
        this.resolver = resolver;
        this.sharedObjectCache = services.get(SharedObjectCache.class);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        return this.resolveObserverMethods((Type)event.getClass(), bindings);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        HashSet<Annotation> qualifierSet = new HashSet<Annotation>(Arrays.asList(qualifiers));
        this.notifyObservers(event, qualifierSet, this.resolveObserverMethods(eventType, qualifiers));
    }

    public void fireEvent(Type eventType, Object event, Set<Annotation> qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        this.notifyObservers(event, qualifiers, this.resolveObserverMethods(eventType, qualifiers));
    }

    private <T> void notifyObservers(T event, Set<Annotation> qualifiers, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observerMethod : observers) {
            if (!(observerMethod instanceof ObserverMethodImpl) && !qualifiers.contains(AnyLiteral.INSTANCE)) {
                qualifiers = new HashSet<Annotation>(qualifiers);
                qualifiers.add(AnyLiteral.INSTANCE);
                qualifiers = Collections.unmodifiableSet(qualifiers);
            }
            this.notifyObserver(event, qualifiers, observerMethod);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(this.sharedObjectCache.getTypeClosureHolder(eventType).get()).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosureHolder(eventType).get();
        Resolvable resolvable = new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void clear() {
        this.resolver.clear();
    }

    protected <T> void notifyObserver(T event, Set<Annotation> qualifiers, ObserverMethod<? super T> observer) {
        observer.notify(event, qualifiers);
    }
}

