/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import org.jboss.weld.bootstrap.BootstrapConfiguration;
import org.jboss.weld.executor.FixedThreadPoolExecutorServices;
import org.jboss.weld.executor.ProfilingExecutorServices;
import org.jboss.weld.executor.SingleThreadExecutorServices;
import org.jboss.weld.manager.api.ExecutorServices;

public class ExecutorServicesFactory {
    private ExecutorServicesFactory() {
    }

    public static ExecutorServices create(BootstrapConfiguration configuration) {
        if (!configuration.isThreadingEnabled()) {
            return null;
        }
        if (!configuration.isConcurrentDeployerEnabled()) {
            return new SingleThreadExecutorServices();
        }
        ExecutorServices executor = new FixedThreadPoolExecutorServices(configuration.getDeployerThreads());
        if (configuration.isDebug()) {
            executor = new ProfilingExecutorServices(executor);
        }
        return executor;
    }
}

