/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClassConstructorInjectionPointWrapper<T>
extends ConstructorInjectionPoint<T> {
    private ConstructorInjectionPoint<T> originalConstructorInjectionPoint;
    private final boolean decorator;
    private final int delegateInjectionPointPosition;
    private final Bean<?> bean;

    public ProxyClassConstructorInjectionPointWrapper(Bean<T> declaringBean, Class<?> declaringComponentClass, EnhancedAnnotatedConstructor<T> weldConstructor, ConstructorInjectionPoint<T> originalConstructorInjectionPoint, BeanManagerImpl manager) {
        super(weldConstructor, declaringBean, declaringComponentClass, InjectionPointFactory.silentInstance(), manager);
        this.decorator = declaringBean instanceof Decorator;
        this.originalConstructorInjectionPoint = originalConstructorInjectionPoint;
        this.bean = declaringBean;
        this.delegateInjectionPointPosition = this.initDelegateInjectionPointPosition();
    }

    private int initDelegateInjectionPointPosition() {
        for (ParameterInjectionPoint<?, T> parameter : this.getParameterInjectionPoints()) {
            if (!parameter.isDelegate()) continue;
            return parameter.getAnnotated().getPosition();
        }
        return -1;
    }

    private boolean hasDelegateInjectionPoint() {
        return this.delegateInjectionPointPosition != -1;
    }

    @Override
    public List<ParameterInjectionPoint<?, T>> getParameterInjectionPoints() {
        return this.originalConstructorInjectionPoint.getParameterInjectionPoints();
    }

    @Override
    public T newInstance(BeanManagerImpl manager, CreationalContext<?> creationalContext, Object[] parameterValues) {
        Object instance = super.newInstance(manager, creationalContext, parameterValues);
        if (this.decorator) {
            TargetBeanInstance beanInstance = null;
            if (this.hasDelegateInjectionPoint()) {
                Object decoratorDelegate = parameterValues[this.delegateInjectionPointPosition];
                beanInstance = new TargetBeanInstance(decoratorDelegate);
            }
            ProxyFactory.setBeanInstance(instance, beanInstance, this.bean);
        } else if (instance instanceof ProxyObject) {
            ((ProxyObject)instance).setHandler(new CombinedInterceptorAndDecoratorStackMethodHandler());
        }
        return instance;
    }
}

