/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDecoratorApplyingInstantiator<T>
implements Instantiator<T> {
    private final Instantiator<T> delegate;
    private final Bean<T> bean;
    private final Class<T> proxyClass;
    private final List<Decorator<?>> decorators;

    public AbstractDecoratorApplyingInstantiator(Instantiator<T> delegate, Bean<T> bean, List<Decorator<?>> decorators) {
        this.delegate = delegate;
        this.bean = bean;
        this.decorators = decorators;
        ProxyFactory factory = new ProxyFactory(bean.getBeanClass(), bean.getTypes(), bean);
        this.proxyClass = factory.getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        InjectionPoint originalInjectionPoint = manager.getServices().get(CurrentInjectionPoint.class).peek();
        return this.applyDecorators(this.delegate.newInstance(ctx, manager), ctx, originalInjectionPoint, manager);
    }

    protected abstract T applyDecorators(T var1, CreationalContext<T> var2, InjectionPoint var3, BeanManagerImpl var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getOuterDelegate(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint, BeanManagerImpl manager) {
        T t;
        TargetBeanInstance beanInstance = new TargetBeanInstance(this.bean, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, this.bean, this.proxyClass, manager, manager.getServices().get(ContextualStore.class), this.decorators);
        DecorationHelper.push(decorationHelper);
        try {
            T outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
            if (outerDelegate == null) {
                throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, this);
            }
            t = outerDelegate;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DecorationHelper.pop();
            throw throwable;
        }
        DecorationHelper.pop();
        return t;
    }

    protected void registerOuterDecorator(ProxyObject instance, T outerDelegate) {
        CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)instance.getHandler();
        wrapperMethodHandler.setOuterDecorator(outerDelegate);
    }

    public Instantiator<T> getDelegate() {
        return this.delegate;
    }

    public Bean<T> getBean() {
        return this.bean;
    }

    public Class<T> getProxyClass() {
        return this.proxyClass;
    }

    public List<Decorator<?>> getDecorators() {
        return this.decorators;
    }

    @Override
    public boolean hasInterceptorSupport() {
        return this.delegate.hasInterceptorSupport();
    }

    @Override
    public boolean hasDecoratorSupport() {
        return true;
    }
}

