/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemberProducer<X, T>
extends AbstractProducer<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final DisposalMethod<?, ?> disposalMethod;
    private final CurrentInjectionPoint currentInjectionPointService;

    public AbstractMemberProducer(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember, DisposalMethod<?, ?> disposalMethod) {
        this.disposalMethod = disposalMethod;
        this.currentInjectionPointService = this.getBeanManager().getServices().get(CurrentInjectionPoint.class);
        this.checkDeclaringBean();
        this.checkProducerReturnType(enhancedMember);
    }

    protected void checkDeclaringBean() {
        if (this.getDeclaringBean() == null && !this.getAnnotated().isStatic()) {
            throw new org.jboss.weld.exceptions.IllegalArgumentException(BeanMessage.DECLARING_BEAN_MISSING, this.getAnnotated());
        }
    }

    protected void checkProducerReturnType(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember) {
        if (enhancedMember.getBaseType() instanceof TypeVariable || enhancedMember.getBaseType() instanceof WildcardType) {
            throw new DefinitionException(BeanMessage.RETURN_TYPE_MUST_BE_CONCRETE, enhancedMember.getBaseType());
        }
        if (enhancedMember.isParameterizedType()) {
            boolean dependent = this.getBean() != null && Dependent.class.equals(this.getBean().getScope());
            for (Type type : enhancedMember.getActualTypeArguments()) {
                if (!dependent && type instanceof TypeVariable) {
                    throw new DefinitionException(BeanMessage.PRODUCER_METHOD_WITH_TYPE_VARIABLE_RETURN_TYPE_MUST_BE_DEPENDENT, enhancedMember);
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException(BeanMessage.PRODUCER_METHOD_CANNOT_HAVE_A_WILDCARD_RETURN_TYPE, enhancedMember);
            }
        }
    }

    protected Object getReceiver(CreationalContext<?> productCreationalContext, CreationalContext<?> receiverCreationalContext) {
        WeldCreationalContext creationalContextImpl;
        X incompleteInstance;
        if (this.getAnnotated().isStatic()) {
            return null;
        }
        if (productCreationalContext instanceof WeldCreationalContext && (incompleteInstance = (creationalContextImpl = (WeldCreationalContext)productCreationalContext).getIncompleteInstance(this.getDeclaringBean())) != null) {
            log.warn(BeanMessage.CIRCULAR_CALL, this.getAnnotated(), this.getDeclaringBean());
            return incompleteInstance;
        }
        return this.getBeanManager().getReference(this.getDeclaringBean(), null, receiverCreationalContext, true);
    }

    private void storeMetadata(CreationalContext<T> creationalContext) {
        if (this.disposalMethod != null) {
            if (this.disposalMethod.hasBeanMetadataParameter()) {
                WeldCreationalContext<T> ctx = this.getWeldCreationalContext(creationalContext);
                this.checkValue(ctx.getContextual());
                ctx.storeContextual();
            }
            if (this.disposalMethod.hasInjectionPointMetadataParameter()) {
                InjectionPoint ip = this.currentInjectionPointService.peek();
                this.checkValue(ip);
                this.getWeldCreationalContext(creationalContext).storeInjectionPoint(ip);
            }
        }
    }

    private <A> WeldCreationalContext<A> getWeldCreationalContext(CreationalContext<A> ctx) {
        if (ctx instanceof WeldCreationalContext) {
            return (WeldCreationalContext)Reflections.cast(ctx);
        }
        throw new IllegalArgumentException("Unable to store values in " + ctx);
    }

    private void checkValue(Object object) {
        InjectionPoint ip = this.currentInjectionPointService.peek();
        if (ip != null && Beans.isPassivatingScope(ip.getBean(), this.getBeanManager()) && !this.isTypeSerializable(object.getClass())) {
            throw new IllegalArgumentException("Unable to store non-serializable " + object + " as a dependency of " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T instance) {
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)null);
        try {
            this.dispose(instance, ctx);
            Object var4_3 = null;
            ctx.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(T instance, CreationalContext<T> ctx) {
        block5: {
            if (this.disposalMethod != null) {
                if (this.disposalMethod.hasInjectionPointMetadataParameter()) {
                    this.loadMetadataForDisposerInvocation(ctx);
                }
                try {
                    Object receiver = this.getReceiver(ctx, ctx);
                    this.disposalMethod.invokeDisposeMethod(receiver, instance, ctx);
                    Object var5_4 = null;
                    if (!this.disposalMethod.hasInjectionPointMetadataParameter()) break block5;
                    this.currentInjectionPointService.pop();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.disposalMethod.hasInjectionPointMetadataParameter()) {
                        this.currentInjectionPointService.pop();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    protected void loadMetadataForDisposerInvocation(CreationalContext<T> ctx) {
        WeldCreationalContext<T> weldCtx = this.getWeldCreationalContext(ctx);
        InjectionPoint ip = weldCtx.loadInjectionPoint();
        if (ip == null) {
            throw new IllegalStateException("Unable to restore InjectionPoint instance.");
        }
        this.currentInjectionPointService.push(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T produce(CreationalContext<T> ctx) {
        T t;
        this.storeMetadata(ctx);
        CreationalContext receiverCreationalContext = this.getBeanManager().createCreationalContext((Contextual)this.getDeclaringBean());
        Object receiver = this.getReceiver(ctx, receiverCreationalContext);
        try {
            t = this.produce(receiver, ctx);
            Object var6_5 = null;
            receiverCreationalContext.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            receiverCreationalContext.release();
            throw throwable;
        }
        return t;
    }

    public DisposalMethod<?, ?> getDisposalMethod() {
        return this.disposalMethod;
    }

    protected boolean isTypeSerializable(Object object) {
        return object instanceof Serializable;
    }

    public abstract BeanManagerImpl getBeanManager();

    public abstract Bean<X> getDeclaringBean();

    @Override
    public abstract Bean<T> getBean();

    @Override
    public abstract AnnotatedMember<? super X> getAnnotated();

    protected abstract T produce(Object var1, CreationalContext<T> var2);

    public String toString() {
        if (this.getDeclaringBean() == null) {
            return "Producer for " + this.getAnnotated();
        }
        if (this.getBean() == null) {
            return "Producer for " + this.getAnnotated() + " declared on " + this.getDeclaringBean();
        }
        return "Producer for " + this.getBean() + " declared on " + this.getDeclaringBean();
    }
}

