/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer.ejb;

import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.bean.proxy.EnterpriseProxyFactory;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanInstantiator<T>
implements Instantiator<T> {
    private final Class<T> proxyClass;
    private final SessionBean<T> bean;

    public SessionBeanInstantiator(EnhancedAnnotatedType<T> type, SessionBean<T> bean) {
        this.bean = bean;
        this.proxyClass = new EnterpriseProxyFactory(type.getJavaClass(), bean).getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        try {
            T instance = SecureReflections.newInstance(this.proxyClass);
            ctx.push(instance);
            ProxyFactory.setBeanInstance(instance, this.createEnterpriseTargetBeanInstance(ctx), this.bean);
            return instance;
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        catch (Exception e) {
            throw new CreationException(BeanMessage.EJB_NOT_FOUND, (Throwable)e, this.proxyClass);
        }
    }

    protected EnterpriseTargetBeanInstance createEnterpriseTargetBeanInstance(CreationalContext<T> creationalContext) {
        return new EnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean, creationalContext));
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    public SessionBean<T> getBean() {
        return this.bean;
    }
}

