/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInterceptionChain
implements InterceptionChain {
    private final Logger log = LoggerFactory.getLogger(SimpleInterceptionChain.class);
    private final Object target;
    private final Method targetMethod;
    private int currentPosition;
    private final List<InterceptorMethodInvocation> interceptorMethodInvocations;

    public SimpleInterceptionChain(Collection<InterceptorInvocation> interceptorInvocations, Object target, Method targetMethod) {
        this.target = target;
        this.targetMethod = targetMethod;
        this.currentPosition = 0;
        this.interceptorMethodInvocations = new ArrayList<InterceptorMethodInvocation>();
        for (InterceptorInvocation interceptorInvocation : interceptorInvocations) {
            this.interceptorMethodInvocations.addAll(interceptorInvocation.getInterceptorMethodInvocations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeNextInterceptor(InvocationContext invocationContext) throws Throwable {
        try {
            if (this.hasNextInterceptor()) {
                Object var4_6;
                int oldCurrentPosition = this.currentPosition;
                try {
                    InterceptorMethodInvocation nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Invoking next interceptor in chain:" + nextInterceptorMethodInvocation.toString());
                    }
                    if (nextInterceptorMethodInvocation.expectsInvocationContext()) {
                        Object object = nextInterceptorMethodInvocation.invoke(invocationContext);
                        Object var6_7 = null;
                        this.currentPosition = oldCurrentPosition;
                        return object;
                    }
                    nextInterceptorMethodInvocation.invoke(null);
                    while (this.hasNextInterceptor()) {
                        nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                        nextInterceptorMethodInvocation.invoke(null);
                    }
                    var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.currentPosition = oldCurrentPosition;
                    throw throwable;
                }
                Object var6_8 = null;
                this.currentPosition = oldCurrentPosition;
                return var4_6;
            }
            if (this.targetMethod == null) {
                return null;
            }
            SecureReflections.ensureAccessible(this.targetMethod);
            if (invocationContext.getMethod() != null) {
                return this.targetMethod.invoke(this.target, invocationContext.getParameters());
            }
            return this.targetMethod.invoke(this.target, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean hasNextInterceptor() {
        return this.currentPosition < this.interceptorMethodInvocations.size();
    }
}

