/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.SyntheticBeanFactory;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.InstanceImpl;
import org.jboss.weld.bean.proxy.ClientProxyProvider;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.AbstractProcessInjectionTarget;
import org.jboss.weld.context.ContextNotActiveException;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.el.Namespace;
import org.jboss.weld.el.WeldELResolver;
import org.jboss.weld.el.WeldExpressionFactory;
import org.jboss.weld.event.GlobalObserverNotifierService;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.exceptions.AmbiguousResolutionException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.InjectionException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnsatisfiedResolutionException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferingFieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferingParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ParameterInjectionPointAttributes;
import org.jboss.weld.injection.producer.AbstractInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetInitializationContext;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.ProducerFieldProducer;
import org.jboss.weld.injection.producer.ProducerMethodProducer;
import org.jboss.weld.injection.producer.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.interceptor.reader.cache.DefaultMetadataCachingReader;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagers;
import org.jboss.weld.manager.BeanTransform;
import org.jboss.weld.manager.CurrentActivity;
import org.jboss.weld.manager.DecoratorTransform;
import org.jboss.weld.manager.Enabled;
import org.jboss.weld.manager.InterceptorTransform;
import org.jboss.weld.manager.MessageDrivenInjectionTarget;
import org.jboss.weld.manager.NamespaceTransform;
import org.jboss.weld.manager.ObserverMethodTransform;
import org.jboss.weld.manager.Transform;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resolution.BeanTypeAssignabilityRules;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.InterceptorResolvableBuilder;
import org.jboss.weld.resolution.NameBasedResolver;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.resolution.TypeSafeDecoratorResolver;
import org.jboss.weld.resolution.TypeSafeInterceptorResolver;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.IterableToIteratorFunction;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagerImpl
implements WeldManager,
Serializable {
    private static final long serialVersionUID = 3021562879133838561L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final transient ServiceRegistry services;
    private final transient Map<Class<? extends Annotation>, List<Context>> contexts;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans;
    private volatile transient Enabled enabled;
    private final transient Set<CurrentActivity> currentActivities;
    private final transient TypeSafeBeanResolver<Bean<?>> beanResolver;
    private final transient TypeSafeResolver<Resolvable, Decorator<?>> decoratorResolver;
    private final transient TypeSafeResolver<InterceptorResolvable, Interceptor<?>> interceptorResolver;
    private final transient NameBasedResolver nameBasedResolver;
    private final transient ELResolver weldELResolver;
    private transient Namespace rootNamespace;
    private final transient ObserverNotifier accessibleObserverNotifier;
    private final transient ObserverNotifier globalObserverNotifier;
    private final transient List<Bean<?>> beans;
    private final transient List<Bean<?>> transitiveBeans;
    private final transient List<Decorator<?>> decorators;
    private final transient List<Interceptor<?>> interceptors;
    private final transient List<String> namespaces;
    private final transient List<ObserverMethod<?>> observers;
    private volatile transient Set<Bean<?>> accessibleSpecializedBeans = Collections.emptySet();
    private final transient Set<Bean<?>> beanSet = Collections.synchronizedSet(new HashSet());
    private final transient HashSet<BeanManagerImpl> accessibleManagers;
    private final transient Set<BeanManagerImpl> childActivities;
    private final AtomicInteger childIds;
    private final String id;
    private final transient ConcurrentMap<Class<?>, InterceptionModel<ClassMetadata<?>, ?>> interceptorModelRegistry = new ConcurrentHashMap();
    private final transient MetadataCachingReader interceptorMetadataReader = new DefaultMetadataCachingReader();

    public static BeanManagerImpl newRootManager(String id, ServiceRegistry serviceRegistry, Enabled enabled) {
        ConcurrentHashMap<Class<? extends Annotation>, List<Context>> contexts = new ConcurrentHashMap<Class<? extends Annotation>, List<Context>>();
        return new BeanManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), new ConcurrentHashMap(), new ClientProxyProvider(), contexts, new CopyOnWriteArraySet<CurrentActivity>(), enabled, id, new AtomicInteger());
    }

    public static BeanManagerImpl newManager(BeanManagerImpl rootManager, String id, ServiceRegistry services) {
        return new BeanManagerImpl(services, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), rootManager.getEnterpriseBeans(), rootManager.getClientProxyProvider(), rootManager.getContexts(), new CopyOnWriteArraySet<CurrentActivity>(), Enabled.EMPTY_ENABLED, id, new AtomicInteger());
    }

    public static BeanManagerImpl newChildActivityManager(BeanManagerImpl parentManager) {
        CopyOnWriteArrayList beans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getBeans());
        CopyOnWriteArrayList transitiveBeans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getTransitiveBeans());
        CopyOnWriteArrayList registeredObservers = new CopyOnWriteArrayList();
        registeredObservers.addAll(parentManager.getObservers());
        CopyOnWriteArrayList<String> namespaces = new CopyOnWriteArrayList<String>();
        namespaces.addAll(parentManager.getNamespaces());
        return new BeanManagerImpl(parentManager.getServices(), beans, transitiveBeans, parentManager.getDecorators(), parentManager.getInterceptors(), registeredObservers, namespaces, parentManager.getEnterpriseBeans(), parentManager.getClientProxyProvider(), parentManager.getContexts(), parentManager.getCurrentActivities(), parentManager.getEnabled(), "" + parentManager.getChildIds().incrementAndGet(), parentManager.getChildIds());
    }

    private BeanManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, List<Bean<?>> transitiveBeans, List<Decorator<?>> decorators, List<Interceptor<?>> interceptors, List<ObserverMethod<?>> observers, List<String> namespaces, Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans, ClientProxyProvider clientProxyProvider, Map<Class<? extends Annotation>, List<Context>> contexts, Set<CurrentActivity> currentActivities, Enabled enabled, String id, AtomicInteger childIds) {
        this.services = serviceRegistry;
        this.beans = beans;
        this.transitiveBeans = transitiveBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.enterpriseBeans = enterpriseBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.currentActivities = currentActivities;
        this.observers = observers;
        this.enabled = enabled;
        this.namespaces = namespaces;
        this.id = id;
        this.childIds = new AtomicInteger();
        this.accessibleManagers = new HashSet();
        BeanTransform beanTransform = new BeanTransform(this);
        this.beanResolver = new TypeSafeBeanResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.decoratorResolver = new TypeSafeDecoratorResolver(this, this.createDynamicAccessibleIterable(DecoratorTransform.INSTANCE));
        this.interceptorResolver = new TypeSafeInterceptorResolver(this, this.createDynamicAccessibleIterable(InterceptorTransform.INSTANCE));
        this.nameBasedResolver = new NameBasedResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.weldELResolver = new WeldELResolver(this);
        this.childActivities = new CopyOnWriteArraySet<BeanManagerImpl>();
        TypeSafeObserverResolver accessibleObserverResolver = new TypeSafeObserverResolver(this.getServices().get(MetaAnnotationStore.class), this.createDynamicAccessibleIterable(ObserverMethodTransform.INSTANCE));
        this.accessibleObserverNotifier = ObserverNotifier.of(accessibleObserverResolver, this.getServices());
        GlobalObserverNotifierService globalObserverNotifierService = this.services.get(GlobalObserverNotifierService.class);
        this.globalObserverNotifier = globalObserverNotifierService.getGlobalObserverNotifier();
        globalObserverNotifierService.registerBeanManager(this);
    }

    private <T> Iterable<T> createDynamicAccessibleIterable(final Transform<T> transform) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Set iterable = BeanManagers.buildAccessibleClosure(BeanManagerImpl.this, transform);
                return Iterators.concat(Iterators.transform(iterable.iterator(), IterableToIteratorFunction.instance()));
            }
        };
    }

    public void addAccessibleBeanManager(BeanManagerImpl accessibleBeanManager) {
        this.accessibleManagers.add(accessibleBeanManager);
        this.beanResolver.clear();
        this.interceptorResolver.clear();
        this.decoratorResolver.clear();
        this.accessibleObserverNotifier.clear();
    }

    public HashSet<BeanManagerImpl> getAccessibleManagers() {
        return this.accessibleManagers;
    }

    public void addBean(Bean<?> bean) {
        this.addBean(bean, this.beans, this.transitiveBeans);
    }

    public void addBeans(Collection<? extends Bean<?>> beans) {
        ArrayList beanList = new ArrayList(beans.size());
        ArrayList transitiveBeans = new ArrayList(beans.size());
        for (Bean<?> bean : beans) {
            this.addBean(bean, beanList, transitiveBeans);
        }
        this.beans.addAll(beanList);
        this.transitiveBeans.addAll(transitiveBeans);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addBeans(beanList);
        }
    }

    private void addBean(Bean<?> bean, List<Bean<?>> beanList, List<Bean<?>> transitiveBeans) {
        if (this.beanSet.add(bean)) {
            log.debug(BootstrapMessage.FOUND_BEAN, bean);
            beanList.add(bean);
            if (bean instanceof SessionBean) {
                SessionBean enterpriseBean = (SessionBean)bean;
                this.enterpriseBeans.put(enterpriseBean.getEjbDescriptor(), enterpriseBean);
            }
            if (bean instanceof PassivationCapable) {
                Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
            }
            this.registerBeanNamespace(bean);
            if (bean instanceof ExtensionBean || bean instanceof SessionBean || !(bean instanceof NewBean) && !(bean instanceof AbstractBuiltInBean)) {
                transitiveBeans.add(bean);
            }
        }
    }

    public void addDecorator(Decorator<?> bean) {
        this.decorators.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent(bean);
        this.decoratorResolver.clear();
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        return this.globalObserverNotifier.resolveObserverMethods(event, bindings);
    }

    public void addInterceptor(Interceptor<?> bean) {
        this.interceptors.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent(bean);
        this.interceptorResolver.clear();
    }

    public Enabled getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Enabled enabled) {
        this.enabled = enabled;
    }

    public boolean isBeanEnabled(Bean<?> bean) {
        return Beans.isBeanEnabled(bean, this.getEnabled());
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(beanType, this).addQualifiers(qualifiers).create();
        return this.beanResolver.resolve(resolvable, Reflections.isCacheable(qualifiers));
    }

    public Set<Bean<?>> getBeans(Type beanType, Set<Annotation> qualifiers) {
        return this.beanResolver.resolve(new ResolvableBuilder(beanType, this).addQualifiers(qualifiers).create(), Reflections.isCacheable(qualifiers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Bean<?>> getBeans(InjectionPoint injectionPoint) {
        Set<Bean<?>> set;
        block3: {
            boolean registerInjectionPoint = this.isRegisterableInjectionPoint(injectionPoint);
            CurrentInjectionPoint currentInjectionPoint = null;
            if (registerInjectionPoint) {
                currentInjectionPoint = this.services.get(CurrentInjectionPoint.class);
                currentInjectionPoint.push(injectionPoint);
            }
            try {
                set = this.beanResolver.resolve(new ResolvableBuilder(injectionPoint, this).create(), true);
                Object var6_5 = null;
                if (!registerInjectionPoint) break block3;
                currentInjectionPoint.pop();
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (!registerInjectionPoint) break block4;
                    currentInjectionPoint.pop();
                }
                throw throwable;
            }
        }
        return set;
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        if (bean.getName() != null && bean.getName().indexOf(46) > 0) {
            this.namespaces.add(bean.getName().substring(0, bean.getName().lastIndexOf(46)));
        }
    }

    public Map<EjbDescriptor<?>, SessionBean<?>> getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    List<Bean<?>> getTransitiveBeans() {
        return Collections.unmodifiableList(this.transitiveBeans);
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public List<Interceptor<?>> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public Iterable<Bean<?>> getAccessibleBeans() {
        return this.createDynamicAccessibleIterable(new BeanTransform(this));
    }

    public Iterable<Interceptor<?>> getAccessibleInterceptors() {
        return this.createDynamicAccessibleIterable(new InterceptorTransform());
    }

    public Iterable<Decorator<?>> getAccessibleDecorators() {
        return this.createDynamicAccessibleIterable(new DecoratorTransform());
    }

    public void addContext(Context context) {
        Class<? extends Annotation> scope = context.getScope();
        List<Context> contextList = this.contexts.get(scope);
        if (contextList == null) {
            contextList = new CopyOnWriteArrayList<Context>();
            this.contexts.put(scope, contextList);
        }
        contextList.add(context);
    }

    public void addObserver(ObserverMethod<?> observer) {
        this.observers.add(observer);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addObserver(observer);
        }
    }

    @Override
    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.globalObserverNotifier.fireEvent(event, qualifiers);
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        Context activeContext = null;
        List<Context> ctx = this.contexts.get(scopeType);
        if (ctx == null) {
            throw new ContextNotActiveException(BeanManagerMessage.CONTEXT_NOT_ACTIVE, scopeType.getName());
        }
        for (Context context : ctx) {
            if (!context.isActive()) continue;
            if (activeContext == null) {
                activeContext = context;
                continue;
            }
            throw new IllegalStateException(BeanManagerMessage.DUPLICATE_ACTIVE_CONTEXTS, scopeType.getName());
        }
        if (activeContext == null) {
            throw new ContextNotActiveException(BeanManagerMessage.CONTEXT_NOT_ACTIVE, scopeType.getName());
        }
        return activeContext;
    }

    public Object getReference(Bean<?> bean, Type requestedType, CreationalContext<?> creationalContext, boolean noProxy) {
        if (creationalContext instanceof WeldCreationalContext) {
            creationalContext = ((WeldCreationalContext)creationalContext).getCreationalContext(bean);
        }
        if (!noProxy && this.isProxyRequired(bean)) {
            if (creationalContext != null || this.getContext(bean.getScope()).get(bean) != null) {
                if (requestedType == null) {
                    return this.clientProxyProvider.getClientProxy(bean);
                }
                return this.clientProxyProvider.getClientProxy(bean, requestedType);
            }
            return null;
        }
        return this.getContext(bean.getScope()).get((Contextual)Reflections.cast(bean), creationalContext);
    }

    private boolean isProxyRequired(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyRequired();
        }
        return this.isNormalScope(bean.getScope());
    }

    @Override
    public Object getReference(Bean<?> bean, Type requestedType, CreationalContext<?> creationalContext) {
        if (bean == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_BEAN_ARGUMENT, new Object[0]);
        }
        if (requestedType == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_BEAN_TYPE_ARGUMENT, new Object[0]);
        }
        if (creationalContext == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_CREATIONAL_CONTEXT_ARGUMENT, new Object[0]);
        }
        if (!BeanTypeAssignabilityRules.instance().matches(requestedType, bean.getTypes())) {
            throw new IllegalArgumentException(BeanManagerMessage.SPECIFIED_TYPE_NOT_BEAN_TYPE, requestedType, bean);
        }
        return this.getReference(bean, requestedType, creationalContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(InjectionPoint injectionPoint, Bean<?> resolvedBean, CreationalContext<?> creationalContext) {
        Object object;
        block13: {
            Type requestedType;
            CurrentInjectionPoint currentInjectionPoint;
            boolean delegateInjectionPoint;
            boolean registerInjectionPoint;
            block9: {
                Object object2;
                block12: {
                    WeldCreationalContext wbCreationalContext;
                    block10: {
                        Object obj;
                        block11: {
                            if (resolvedBean == null) {
                                throw new IllegalArgumentException(BeanManagerMessage.NULL_BEAN_ARGUMENT, new Object[0]);
                            }
                            if (creationalContext == null) {
                                throw new IllegalArgumentException(BeanManagerMessage.NULL_CREATIONAL_CONTEXT_ARGUMENT, new Object[0]);
                            }
                            registerInjectionPoint = this.isRegisterableInjectionPoint(injectionPoint);
                            delegateInjectionPoint = injectionPoint != null && injectionPoint.isDelegate();
                            currentInjectionPoint = null;
                            if (registerInjectionPoint) {
                                currentInjectionPoint = this.services.get(CurrentInjectionPoint.class);
                                currentInjectionPoint.push(injectionPoint);
                            }
                            try {
                                if (injectionPoint != null && this.isNormalScope(resolvedBean.getScope()) && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                                    throw new UnproxyableResolutionException(BeanManagerMessage.UNPROXYABLE_RESOLUTION, resolvedBean, injectionPoint);
                                }
                                requestedType = null;
                                if (injectionPoint != null) {
                                    requestedType = injectionPoint.getType();
                                }
                                if (!(creationalContext instanceof WeldCreationalContext)) break block9;
                                wbCreationalContext = (WeldCreationalContext)creationalContext;
                                Object incompleteInstance = wbCreationalContext.getIncompleteInstance(resolvedBean);
                                if (incompleteInstance == null) break block10;
                                obj = incompleteInstance;
                                Object var12_13 = null;
                                if (!registerInjectionPoint) break block11;
                                currentInjectionPoint.pop();
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var12_16 = null;
                                    if (!registerInjectionPoint) break block14;
                                    currentInjectionPoint.pop();
                                }
                                throw throwable;
                            }
                        }
                        return obj;
                    }
                    object2 = this.getReference(resolvedBean, requestedType, wbCreationalContext, delegateInjectionPoint);
                    Object var12_14 = null;
                    if (!registerInjectionPoint) break block12;
                    currentInjectionPoint.pop();
                }
                return object2;
            }
            object = this.getReference(resolvedBean, requestedType, creationalContext, delegateInjectionPoint);
            Object var12_15 = null;
            if (!registerInjectionPoint) break block13;
            currentInjectionPoint.pop();
        }
        return object;
    }

    @Override
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        if (injectionPoint.isDelegate()) {
            return DecorationHelper.peek().getNextDelegate(injectionPoint, creationalContext);
        }
        Bean resolvedBean = this.getBean(new ResolvableBuilder(injectionPoint, this).create());
        return this.getReference(injectionPoint, resolvedBean, creationalContext);
    }

    public <T> Bean<T> getBean(Resolvable resolvable) {
        Bean bean = (Bean)Reflections.cast(this.resolve(this.beanResolver.resolve(resolvable, true)));
        if (bean == null) {
            throw new UnsatisfiedResolutionException(BeanManagerMessage.UNRESOLVABLE_ELEMENT, resolvable);
        }
        if (this.isNormalScope(bean.getScope()) && !Beans.isBeanProxyable(bean)) {
            throw Proxies.getUnproxyableTypesException(bean);
        }
        return bean;
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        return this.nameBasedResolver.resolve(name);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkResolveDecoratorsArguments(types);
        return new ArrayList(this.decoratorResolver.resolve(new ResolvableBuilder(this).addTypes(types).addQualifiers(qualifiers).create(), Reflections.isCacheable(qualifiers)));
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Set<Annotation> qualifiers) {
        this.checkResolveDecoratorsArguments(types);
        return new ArrayList(this.decoratorResolver.resolve(new ResolvableBuilder(this).addTypes(types).addQualifiers(qualifiers).create(), true));
    }

    private void checkResolveDecoratorsArguments(Set<Type> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException(BeanManagerMessage.NO_DECORATOR_TYPES, new Object[0]);
        }
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (interceptorBindings.length == 0) {
            throw new IllegalArgumentException(BeanManagerMessage.INTERCEPTOR_BINDINGS_EMPTY, new Object[0]);
        }
        for (Annotation annotation : interceptorBindings) {
            if (this.isInterceptorBinding(annotation.annotationType())) continue;
            throw new IllegalArgumentException(BeanManagerMessage.NOT_INTERCEPTOR_BINDING_TYPE, annotation);
        }
        Set<Annotation> flattenedInterceptorBindings = Interceptors.flattenInterceptorBindings(this, Arrays.asList(interceptorBindings), true, true);
        return this.resolveInterceptors(type, flattenedInterceptorBindings);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Collection<Annotation> interceptorBindings) {
        InterceptorResolvable interceptorResolvable = ((InterceptorResolvableBuilder)new InterceptorResolvableBuilder((Type)((Object)Object.class), this).setInterceptionType(type).addQualifiers((Collection)interceptorBindings)).create();
        return new ArrayList(this.interceptorResolver.resolve(interceptorResolvable, Reflections.isCacheable(interceptorBindings)));
    }

    public TypeSafeBeanResolver<Bean<?>> getBeanResolver() {
        return this.beanResolver;
    }

    public TypeSafeResolver<Resolvable, Decorator<?>> getDecoratorResolver() {
        return this.decoratorResolver;
    }

    public ObserverNotifier getAccessibleObserverNotifier() {
        return this.accessibleObserverNotifier;
    }

    public ObserverNotifier getGlobalObserverNotifier() {
        return this.globalObserverNotifier;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled alternatives: " + this.getEnabled().getAlternativeClasses() + " " + this.getEnabled().getAlternativeStereotypes() + "\n");
        buffer.append("Registered contexts: " + this.contexts.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanManagerImpl) {
            BeanManagerImpl that = (BeanManagerImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public BeanManagerImpl createActivity() {
        BeanManagerImpl childActivity = BeanManagerImpl.newChildActivityManager(this);
        this.childActivities.add(childActivity);
        Container.instance().addActivity(childActivity);
        return childActivity;
    }

    @Override
    public BeanManagerImpl setCurrent(Class<? extends Annotation> scopeType) {
        if (!this.getServices().get(MetaAnnotationStore.class).getScopeModel(scopeType).isNormal()) {
            throw new IllegalArgumentException(BeanManagerMessage.NON_NORMAL_SCOPE, scopeType);
        }
        this.currentActivities.add(new CurrentActivity(this.getContext(scopeType), this));
        return this;
    }

    @Override
    public BeanManagerImpl getCurrent() {
        CurrentActivity activeCurrentActivity = null;
        for (CurrentActivity currentActivity : this.currentActivities) {
            if (!currentActivity.getContext().isActive()) continue;
            if (activeCurrentActivity == null) {
                activeCurrentActivity = currentActivity;
                continue;
            }
            throw new IllegalStateException(BeanManagerMessage.TOO_MANY_ACTIVITIES, this.currentActivities);
        }
        if (activeCurrentActivity == null) {
            return this;
        }
        return activeCurrentActivity.getManager();
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    protected Object readResolve() {
        return Container.instance().activityManager(this.id);
    }

    public ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected Map<Class<? extends Annotation>, List<Context>> getContexts() {
        return this.contexts;
    }

    protected List<String> getNamespaces() {
        return this.namespaces;
    }

    public Iterable<String> getAccessibleNamespaces() {
        return this.createDynamicAccessibleIterable(new NamespaceTransform());
    }

    private Set<CurrentActivity> getCurrentActivities() {
        return this.currentActivities;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public AtomicInteger getChildIds() {
        return this.childIds;
    }

    public List<ObserverMethod<?>> getObservers() {
        return this.observers;
    }

    public Namespace getRootNamespace() {
        if (this.rootNamespace == null) {
            this.rootNamespace = new Namespace(this.createDynamicAccessibleIterable(new NamespaceTransform()));
        }
        return this.rootNamespace;
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        AnnotatedTypeValidator.validateAnnotatedType(type);
        try {
            EnhancedAnnotatedType<T> enhancedType = this.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type);
            AbstractInjectionTarget<T> injectionTarget = this.createInjectionTarget(enhancedType, null);
            this.getServices().get(InjectionTargetService.class).validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> AbstractInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean) {
        AbstractInjectionTarget injectionTarget = null;
        injectionTarget = bean instanceof DecoratorImpl || type.isAnnotationPresent(javax.decorator.Decorator.class) || type.isAbstract() ? new DecoratorInjectionTarget<T>(type, bean, this) : (bean instanceof SessionBean ? new SessionBeanInjectionTarget<T>(type, (SessionBean)bean, this) : new DefaultInjectionTarget<T>(type, bean, this));
        this.getServices().get(InjectionTargetService.class).addInjectionTargetToBeInitialized(new InjectionTargetInitializationContext<T>(type, injectionTarget));
        return injectionTarget;
    }

    private <T> InjectionTarget<T> createMessageDrivenInjectionTarget(AnnotatedType<T> type) {
        return new MessageDrivenInjectionTarget<T>(this.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type), this);
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(EjbDescriptor<T> descriptor) {
        if (descriptor.isMessageDriven()) {
            InjectionTarget<T> injectionTarget = this.createMessageDrivenInjectionTarget(this.createAnnotatedType(descriptor.getBeanClass()));
            this.getServices().get(InjectionTargetService.class).validateProducer(injectionTarget);
            return injectionTarget;
        }
        Producer injectionTarget = ((AbstractClassBean)this.getBean((EjbDescriptor)descriptor)).getProducer();
        this.getServices().get(InjectionTargetService.class).validateProducer(injectionTarget);
        return injectionTarget;
    }

    public <X> Producer<?> createProducer(AnnotatedField<X> field) {
        AnnotatedTypeValidator.validateAnnotatedMember(field);
        try {
            EnhancedAnnotatedField enhancedField = (EnhancedAnnotatedField)this.getServices().get(MemberTransformer.class).loadEnhancedMember(field);
            Producer producer = this.createProducer(enhancedField, null, null, null);
            this.getServices().get(InjectionTargetService.class).validateProducer(producer);
            return producer;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <X, T> Producer<T> createProducer(EnhancedAnnotatedField<T, X> enhancedField, DisposalMethod<X, T> disposalMethod, final Bean<X> declaringBean, final Bean<T> bean) {
        final AnnotatedField<X> field = enhancedField.slim();
        return new ProducerFieldProducer<X, T>(enhancedField, disposalMethod){

            @Override
            public AnnotatedField<? super X> getAnnotated() {
                return field;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return BeanManagerImpl.this;
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return declaringBean;
            }

            @Override
            public Bean<T> getBean() {
                return bean;
            }
        };
    }

    public <X> Producer<?> createProducer(AnnotatedMethod<X> method) {
        AnnotatedTypeValidator.validateAnnotatedMember(method);
        try {
            EnhancedAnnotatedMethod enhancedMethod = (EnhancedAnnotatedMethod)this.getServices().get(MemberTransformer.class).loadEnhancedMember(method);
            Producer producer = this.createProducer(enhancedMethod, null, null, null);
            this.getServices().get(InjectionTargetService.class).validateProducer(producer);
            return producer;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <X, T> Producer<T> createProducer(EnhancedAnnotatedMethod<T, X> enhancedMethod, DisposalMethod<X, T> disposalMethod, final Bean<X> declaringBean, final Bean<T> bean) {
        final AnnotatedMethod<X> method = enhancedMethod.slim();
        return new ProducerMethodProducer<X, T>(enhancedMethod, disposalMethod){

            @Override
            public AnnotatedMethod<? super X> getAnnotated() {
                return method;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return BeanManagerImpl.this;
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return declaringBean;
            }

            @Override
            public Bean<T> getBean() {
                return bean;
            }
        };
    }

    @Override
    public void validate(InjectionPoint ij) {
        try {
            this.getServices().get(Validator.class).validateInjectionPoint(ij, this);
        }
        catch (DeploymentException e) {
            throw new InjectionException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        InterceptorBindingModel<? extends Annotation> model = this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(bindingType);
        if (model.isValid()) {
            return model.getMetaAnnotations();
        }
        throw new IllegalArgumentException(BeanManagerMessage.NOT_INTERCEPTOR_BINDING_TYPE, bindingType);
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        return (Bean)this.getServices().get(ContextualStore.class).getContextual(id);
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        StereotypeModel<? extends Annotation> model = this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype);
        if (model.isValid()) {
            return model.getMetaAnnotations();
        }
        throw new IllegalArgumentException(BeanManagerMessage.NOT_STEREOTYPE, stereotype);
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotationType).isValid();
    }

    @Override
    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotationType).isValid();
    }

    @Override
    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isNormal();
    }

    @Override
    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isPassivating();
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType).isValid();
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getStereotype(annotationType).isValid();
    }

    @Override
    public ELResolver getELResolver() {
        return this.weldELResolver;
    }

    @Override
    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return new WeldExpressionFactory(expressionFactory);
    }

    public <T> WeldCreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return this.getServices().get(ClassTransformer.class).getAnnotatedType(type);
    }

    public <T> EnhancedAnnotatedType<T> createEnhancedAnnotatedType(Class<T> type) {
        return this.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        Set<Bean<X>> resolvedBeans = this.beanResolver.resolve(beans);
        if (resolvedBeans.size() == 1) {
            return resolvedBeans.iterator().next();
        }
        if (resolvedBeans.size() == 0) {
            return null;
        }
        throw new AmbiguousResolutionException(BeanManagerMessage.AMBIGUOUS_BEANS_FOR_DEPENDENCY, beans);
    }

    @Override
    public <T> EjbDescriptor<T> getEjbDescriptor(String beanName) {
        return this.getServices().get(EjbDescriptors.class).get(beanName);
    }

    public <T> SessionBean<T> getBean(EjbDescriptor<T> descriptor) {
        return (SessionBean)Reflections.cast(this.getEnterpriseBeans().get(descriptor));
    }

    public void cleanup() {
        this.services.cleanup();
        this.accessibleManagers.clear();
        this.beanResolver.clear();
        this.beans.clear();
        this.childActivities.clear();
        this.clientProxyProvider.clear();
        this.contexts.clear();
        this.currentActivities.clear();
        this.decoratorResolver.clear();
        this.decorators.clear();
        this.enterpriseBeans.clear();
        this.interceptorResolver.clear();
        this.interceptors.clear();
        this.nameBasedResolver.clear();
        this.namespaces.clear();
        this.accessibleObserverNotifier.clear();
        this.observers.clear();
    }

    public ConcurrentMap<Class<?>, InterceptionModel<ClassMetadata<?>, ?>> getInterceptorModelRegistry() {
        return this.interceptorModelRegistry;
    }

    public MetadataCachingReader getInterceptorMetadataReader() {
        return this.interceptorMetadataReader;
    }

    @Override
    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> annotatedType) {
        return AbstractProcessInjectionTarget.fire(this, annotatedType, this.createInjectionTarget(annotatedType));
    }

    public Set<QualifierInstance> extractInterceptorBindingsForQualifierInstance(Iterable<QualifierInstance> annotations) {
        HashSet<QualifierInstance> foundInterceptionBindingTypes = new HashSet<QualifierInstance>();
        for (QualifierInstance annotation : annotations) {
            if (!this.isInterceptorBinding(annotation.getAnnotationClass())) continue;
            foundInterceptionBindingTypes.add(annotation);
        }
        return foundInterceptionBindingTypes;
    }

    @Override
    public Instance<Object> instance() {
        return InstanceImpl.of(InstanceInjectionPoint.INSTANCE, this.createCreationalContext((Contextual)null), this);
    }

    @Override
    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        EnhancedAnnotatedType<T> clazz = this.services.get(ClassTransformer.class).getEnhancedAnnotatedType(type);
        if (this.services.get(EjbDescriptors.class).contains(type.getJavaClass())) {
            return BeanAttributesFactory.forSessionBean(clazz, this.services.get(EjbDescriptors.class).getUnique(clazz.getJavaClass()), this);
        }
        return BeanAttributesFactory.forBean(clazz, this);
    }

    @Override
    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> member) {
        return this.internalCreateBeanAttributes(member);
    }

    public <X> BeanAttributes<?> internalCreateBeanAttributes(AnnotatedMember<X> member) {
        EnhancedAnnotated weldMember = null;
        if (!(member instanceof AnnotatedField) && !(member instanceof AnnotatedMethod)) {
            throw new IllegalArgumentException(BeanManagerMessage.INCORRECT_PRODUCER_MEMBER, member);
        }
        weldMember = (EnhancedAnnotated)this.services.get(MemberTransformer.class).loadEnhancedMember(member);
        return BeanAttributesFactory.forBean(weldMember, this);
    }

    @Override
    public Bean<?> createBean(BeanAttributes<?> attributes, Class<?> beanClass, InjectionTarget<?> injectionTarget) {
        return SyntheticBeanFactory.create(attributes, beanClass, injectionTarget, this);
    }

    @Override
    public Bean<?> createBean(BeanAttributes<?> attributes, Class<?> beanClass, Producer<?> producer) {
        return SyntheticBeanFactory.create(attributes, beanClass, producer, this);
    }

    @Override
    public FieldInjectionPointAttributes<?, ?> createInjectionPoint(AnnotatedField<?> field) {
        AnnotatedTypeValidator.validateAnnotatedMember(field);
        return this.validateInjectionPoint(this.createFieldInjectionPoint(field));
    }

    private <X> FieldInjectionPointAttributes<?, X> createFieldInjectionPoint(AnnotatedField<X> field) {
        EnhancedAnnotatedField enhancedField = (EnhancedAnnotatedField)this.services.get(MemberTransformer.class).loadEnhancedMember(field);
        return InferingFieldInjectionPointAttributes.of(enhancedField, null, field.getDeclaringType().getJavaClass(), this);
    }

    @Override
    public ParameterInjectionPointAttributes<?, ?> createInjectionPoint(AnnotatedParameter<?> parameter) {
        AnnotatedTypeValidator.validateAnnotatedParameter(parameter);
        EnhancedAnnotatedParameter<?, ?> enhancedParameter = this.services.get(MemberTransformer.class).load(parameter);
        return this.validateInjectionPoint(InferingParameterInjectionPointAttributes.of(enhancedParameter, null, parameter.getDeclaringCallable().getDeclaringType().getJavaClass(), this));
    }

    private <T extends InjectionPoint> T validateInjectionPoint(T injectionPoint) {
        try {
            this.services.get(Validator.class).validateInjectionPointForDefinitionErrors(injectionPoint, null, this);
        }
        catch (DefinitionException e) {
            throw new IllegalArgumentException(e);
        }
        return injectionPoint;
    }

    @Override
    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        Bean bean = this.resolve(this.getBeans(extensionClass, new Annotation[0]));
        if (bean == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NO_INSTANCE_OF_EXTENSION, extensionClass);
        }
        return (T)((Extension)extensionClass.cast(bean.create(null)));
    }

    private boolean isRegisterableInjectionPoint(InjectionPoint ip) {
        return ip != null && !ip.getType().equals(InjectionPoint.class) && !ip.isDelegate();
    }

    public boolean isSpecialized(Bean<?> bean) {
        return this.accessibleSpecializedBeans.contains(bean);
    }

    public void initializeSpecialization() {
        BeanTransform beanTransform = new BeanTransform(this);
        SpecializationAndEnablementRegistry registry = this.services.get(SpecializationAndEnablementRegistry.class);
        if (!registry.getBeansSpecializedInAnyDeployment().isEmpty()) {
            HashSet specializedBeansTemp = new HashSet();
            for (Bean bean : this.createDynamicAccessibleIterable(beanTransform)) {
                AbstractBean abstractBean;
                if (!(bean instanceof AbstractBean) || !(abstractBean = (AbstractBean)bean).isSpecializing() || !Beans.isBeanEnabled(abstractBean, this.getEnabled())) continue;
                specializedBeansTemp.addAll(registry.resolveSpecializedBeans(abstractBean));
            }
            this.accessibleSpecializedBeans = Collections.unmodifiableSet(specializedBeansTemp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceInjectionPoint
    implements InjectionPoint,
    Serializable {
        private static final InjectionPoint INSTANCE = new InstanceInjectionPoint();
        private transient Type type;
        private transient Set<Annotation> qualifiers;

        private InstanceInjectionPoint() {
        }

        @Override
        public Type getType() {
            if (this.type == null) {
                this.type = new TypeLiteral<Instance<Object>>(){}.getType();
            }
            return this.type;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            if (this.qualifiers == null) {
                this.qualifiers = Arrays2.asSet(DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE);
            }
            return this.qualifiers;
        }

        @Override
        public Bean<?> getBean() {
            return null;
        }

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Annotated getAnnotated() {
            return null;
        }

        @Override
        public boolean isDelegate() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return false;
        }
    }
}

