/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jboss.weld.resolution.EventTypeAssignabilityRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTypeAssignabilityRules
extends EventTypeAssignabilityRules {
    private static final BeanTypeAssignabilityRules INSTANCE = new BeanTypeAssignabilityRules();

    protected BeanTypeAssignabilityRules() {
    }

    public static BeanTypeAssignabilityRules instance() {
        return INSTANCE;
    }

    @Override
    protected boolean areActualTypeArgumentsMatching(EventTypeAssignabilityRules.ActualTypeHolder requiredType, Type[] otherActualTypeArguments) {
        if (requiredType.getActualTypeArguments().length == 0) {
            return this.isArrayOfUnboundedTypeVariablesOrObjects(otherActualTypeArguments);
        }
        return super.areActualTypeArgumentsMatching(requiredType, otherActualTypeArguments);
    }

    protected boolean isArrayOfUnboundedTypeVariablesOrObjects(Type[] types) {
        for (Type type : types) {
            Type[] bounds;
            if (Object.class.equals((Object)type) || type instanceof TypeVariable && ((bounds = ((TypeVariable)type).getBounds()) == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean matches(WildcardType requiredType, Type beanType) {
        if (beanType instanceof TypeVariable) {
            TypeVariable beanTypeVariable = (TypeVariable)beanType;
            if (this.areTypesInsideBounds(beanTypeVariable.getBounds(), requiredType.getLowerBounds(), requiredType.getUpperBounds())) {
                return true;
            }
            return this.areTypesInsideBounds(requiredType.getUpperBounds(), EMPTY_TYPES, beanTypeVariable.getBounds());
        }
        return this.isTypeInsideBounds(beanType, requiredType.getLowerBounds(), requiredType.getUpperBounds());
    }

    @Override
    protected boolean matches(TypeVariable<?> requiredType, Type beanType) {
        if (beanType instanceof TypeVariable) {
            TypeVariable<?> requiredTypeVariable = requiredType;
            TypeVariable beanTypeVariable = (TypeVariable)beanType;
            return this.areTypesInsideBounds(requiredTypeVariable.getBounds(), EMPTY_TYPES, beanTypeVariable.getBounds());
        }
        return false;
    }

    @Override
    protected boolean isAssignableFrom(EventTypeAssignabilityRules.ActualTypeHolder requiredType, Type otherType) {
        TypeVariable typeVariable;
        if ((otherType = this.wrapWithinTypeHolder(otherType)) instanceof EventTypeAssignabilityRules.ActualTypeHolder) {
            return this.isAssignableFrom(requiredType, (EventTypeAssignabilityRules.ActualTypeHolder)otherType);
        }
        return otherType instanceof TypeVariable && this.isTypeInsideBounds(requiredType, EMPTY_TYPES, (typeVariable = (TypeVariable)otherType).getBounds());
    }
}

