/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorResolvableBuilder
extends ResolvableBuilder {
    private InterceptionType interceptionType;

    public InterceptorResolvableBuilder(BeanManagerImpl manager) {
        super(manager);
    }

    public InterceptorResolvableBuilder(Type type, BeanManagerImpl manager) {
        super(type, manager);
    }

    @Override
    protected void checkQualifier(Annotation qualifier, QualifierInstance qualifierInstance, Class<? extends Annotation> annotationType) {
        if (!this.getMetaAnnotationStore().getInterceptorBindingModel(annotationType).isValid()) {
            throw new IllegalArgumentException(BeanManagerMessage.INTERCEPTOR_RESOLUTION_WITH_NONBINDING_TYPE, qualifier);
        }
        if (this.qualifierInstances.contains(qualifierInstance)) {
            throw new IllegalArgumentException(BeanManagerMessage.DUPLICATE_INTERCEPTOR_BINDING, this.qualifiers);
        }
    }

    public InterceptorResolvableBuilder setInterceptionType(InterceptionType interceptionType) {
        this.interceptionType = interceptionType;
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifier(Annotation qualifier) {
        super.addQualifier(qualifier);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Collection<Annotation> qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addType(Type type) {
        super.addType(type);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addTypes(Set<Type> types) {
        super.addTypes(types);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        super.setDeclaringBean(declaringBean);
        return this;
    }

    @Override
    public InterceptorResolvable create() {
        if (this.qualifiers.size() == 0) {
            throw new IllegalArgumentException(BeanManagerMessage.INTERCEPTOR_BINDINGS_EMPTY, new Object[0]);
        }
        return new InterceptorResolvableImpl(this.rawType, this.types, this.mappedQualifiers, this.declaringBean, this.interceptionType, this.qualifierInstances);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterceptorResolvableImpl
    extends ResolvableBuilder.ResolvableImpl
    implements InterceptorResolvable {
        private final InterceptionType interceptionType;

        private InterceptorResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Map<Class<? extends Annotation>, Annotation> mappedQualifiers, Bean<?> declaringBean, InterceptionType interceptionType, Set<QualifierInstance> instances) {
            super(rawType, typeClosure, mappedQualifiers, declaringBean, instances, false);
            this.interceptionType = interceptionType;
        }

        @Override
        public InterceptionType getInterceptionType() {
            return this.interceptionType;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getInterceptionType().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Resolvable) {
                Resolvable r = (Resolvable)o;
                return super.equals(r) && r instanceof InterceptorResolvable && this.getInterceptionType().equals((Object)((InterceptorResolvable)r).getInterceptionType());
            }
            return false;
        }
    }
}

