/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Provider;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.BeanTypeAssignabilityRules;
import org.jboss.weld.resolution.DelegateInjectionPointAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<Resolvable, T> {
    private final BeanManagerImpl beanManager;
    private final ConcurrentMap<Set<Bean<?>>, Set<Bean<?>>> disambiguatedBeans;
    private final LazyValueHolder<Map<Type, ArrayList<T>>> beansByType;

    public TypeSafeBeanResolver(BeanManagerImpl beanManager, final Iterable<T> beans) {
        super(beans);
        this.beanManager = beanManager;
        this.disambiguatedBeans = new MapMaker().makeComputingMap(new BeanDisambiguation());
        this.beansByType = new LazyValueHolder<Map<Type, ArrayList<T>>>(){

            @Override
            protected Map<Type, ArrayList<T>> computeValue() {
                HashMap map = new HashMap();
                for (Bean bean : beans) {
                    this.mapBean(map, bean);
                }
                this.trimArrayListsToSize(map);
                return Collections.unmodifiableMap(map);
            }

            private void mapBean(Map<Type, ArrayList<T>> map, T bean) {
                for (Type type : bean.getTypes()) {
                    Class clazz;
                    this.mapTypeToBean(map, type, bean);
                    if (type instanceof ParameterizedType) {
                        Type rawType = ((ParameterizedType)type).getRawType();
                        this.mapTypeToBean(map, rawType, bean);
                        continue;
                    }
                    if (!(type instanceof Class) || !(clazz = (Class)type).isPrimitive()) continue;
                    Class wrapped = Primitives.wrap(clazz);
                    this.mapTypeToBean(map, wrapped, bean);
                }
            }

            private void mapTypeToBean(Map<Type, ArrayList<T>> map, Type type, T bean) {
                if (!map.containsKey(type)) {
                    map.put(type, new ArrayList());
                }
                map.get(type).add(bean);
            }

            private void trimArrayListsToSize(Map<Type, ArrayList<T>> map) {
                for (Map.Entry entry : map.entrySet()) {
                    entry.getValue().trimToSize();
                }
            }
        };
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        BeanTypeAssignabilityRules rules = null;
        rules = resolvable.isDelegate() ? DelegateInjectionPointAssignabilityRules.instance() : BeanTypeAssignabilityRules.instance();
        return rules.matches(resolvable.getTypes(), bean.getTypes()) && Beans.containsAllQualifiers(resolvable.getQualifiers(), QualifierInstance.qualifiers(this.beanManager, bean));
    }

    @Override
    protected Iterable<? extends T> getAllBeans(Resolvable resolvable) {
        if (resolvable.getTypes().contains(Object.class) || Instance.class.equals(resolvable.getJavaClass()) || Event.class.equals(resolvable.getJavaClass()) || Provider.class.equals(resolvable.getJavaClass()) || resolvable.getTypes().contains(Serializable.class)) {
            return super.getAllBeans(resolvable);
        }
        HashSet<T> beans = new HashSet<T>();
        for (Type type : resolvable.getTypes()) {
            beans.addAll(this.getBeans(type));
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                beans.addAll(this.getBeans(rawType));
                continue;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (!clazz.isPrimitive()) continue;
                clazz = Primitives.wrap(clazz);
                beans.addAll(this.getBeans(clazz));
                continue;
            }
            if (!(type instanceof GenericArrayType)) continue;
            GenericArrayType arrayType = (GenericArrayType)type;
            Class rawArrayType = Reflections.getRawType(arrayType);
            beans.addAll(this.getBeans(rawArrayType));
        }
        return beans;
    }

    private List<T> getBeans(Type type) {
        List beansForType = this.beansByType.get().get(type);
        return beansForType == null ? Collections.emptyList() : beansForType;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.removeDisabledAndSpecializedBeans(matched, this.beanManager);
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    public <X> Set<Bean<? extends X>> resolve(Set<Bean<? extends X>> beans) {
        if (beans.size() <= 1) {
            return beans;
        }
        beans = ImmutableSet.copyOf(beans);
        return (Set)Reflections.cast(this.disambiguatedBeans.get(beans));
    }

    @Override
    public void clear() {
        super.clear();
        this.disambiguatedBeans.clear();
        this.beansByType.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanDisambiguation
    implements Function<Set<Bean<?>>, Set<Bean<?>>> {
        private BeanDisambiguation() {
        }

        @Override
        public Set<Bean<?>> apply(Set<Bean<?>> from) {
            if (from.size() > 1) {
                HashSet allBeans = new HashSet();
                HashSet alternativeBeans = new HashSet();
                for (Bean<?> bean : from) {
                    if (bean.isAlternative()) {
                        alternativeBeans.add(bean);
                    }
                    allBeans.add(bean);
                }
                if (alternativeBeans.isEmpty()) {
                    return ImmutableSet.copyOf(allBeans);
                }
                return ImmutableSet.copyOf(alternativeBeans);
            }
            return ImmutableSet.copyOf(from);
        }
    }
}

