/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.EventTypeAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeObserverResolver
extends TypeSafeResolver<Resolvable, ObserverMethod<?>> {
    private final MetaAnnotationStore metaAnnotationStore;

    public TypeSafeObserverResolver(MetaAnnotationStore metaAnnotationStore, Iterable<ObserverMethod<?>> observers) {
        super(observers);
        this.metaAnnotationStore = metaAnnotationStore;
    }

    @Override
    protected boolean matches(Resolvable resolvable, ObserverMethod<?> observer) {
        return EventTypeAssignabilityRules.instance().matches(observer.getObservedType(), resolvable.getTypes()) && Beans.containsAllQualifiers(QualifierInstance.qualifiers(this.metaAnnotationStore, observer.getObservedQualifiers()), resolvable.getQualifiers()) && (!this.isContainerLifecycleEvent(resolvable) || Extension.class.isAssignableFrom(observer.getBeanClass()));
    }

    protected boolean isContainerLifecycleEvent(Resolvable resolvable) {
        for (Type type : resolvable.getTypes()) {
            if (!Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(type))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<ObserverMethod<?>> filterResult(Set<ObserverMethod<?>> matched) {
        return matched;
    }

    @Override
    protected Set<ObserverMethod<?>> sortResult(Set<ObserverMethod<?>> matched) {
        return matched;
    }

    public MetaAnnotationStore getMetaAnnotationStore() {
        return this.metaAnnotationStore;
    }
}

