/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Field;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldHolder
extends AbstractSerializableHolder<Field> {
    private static final long serialVersionUID = 407021346356682729L;
    private final Class<?> declaringClass;
    private final String fieldName;

    public FieldHolder(Field field) {
        super(field);
        this.declaringClass = field.getDeclaringClass();
        this.fieldName = field.getName();
    }

    @Override
    protected Field initialize() {
        try {
            return this.declaringClass.getDeclaredField(this.fieldName);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.UNABLE_TO_GET_FIELD_ON_DESERIALIZATION, (Throwable)e, this.declaringClass, this.fieldName);
        }
    }
}

