/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Method;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHolder
extends AbstractSerializableHolder<Method> {
    private static final long serialVersionUID = -3033089710155551280L;
    private final Class<?> declaringClass;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodHolder(Method method) {
        super(method);
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    @Override
    protected Method initialize() {
        try {
            return this.declaringClass.getMethod(this.methodName, this.parameterTypes);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.UNABLE_TO_GET_METHOD_ON_DESERIALIZATION, (Throwable)e, this.declaringClass, this.parameterTypes);
        }
    }
}

