/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessModule;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Observers {
    public static final Set<Class<?>> CONTAINER_LIFECYCLE_EVENT_TYPES;

    public static void checkEventObjectType(BeanManagerImpl manager, Type eventType) {
        Observers.checkEventObjectType(manager.getServices().get(SharedObjectCache.class), eventType);
    }

    public static void checkEventObjectType(SharedObjectCache sharedObjectCache, Type eventType) {
        Type[] types;
        Type resolvedType = sharedObjectCache.getResolvedType(eventType);
        if (resolvedType instanceof Class) {
            types = new Type[]{};
        } else if (resolvedType instanceof ParameterizedType) {
            types = ((ParameterizedType)resolvedType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException(UtilMessage.EVENT_TYPE_NOT_ALLOWED, resolvedType);
        }
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException(UtilMessage.TYPE_PARAMETER_NOT_ALLOWED_IN_EVENT_TYPE, resolvedType);
        }
    }

    public static void checkEventObjectType(SharedObjectCache sharedObjectCache, Object event) {
        Observers.checkEventObjectType(sharedObjectCache, event.getClass());
    }

    public static boolean isContainerLifecycleObserverMethod(ObserverMethod<?> method) {
        return CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(method.getObservedType())) || Object.class.equals((Object)method.getObservedType()) && method instanceof ExtensionObserverMethodImpl;
    }

    public static boolean isObserverMethodEnabled(ObserverMethod<?> method, BeanManagerImpl manager) {
        if (method instanceof ObserverMethodImpl) {
            RIBean declaringBean = ((ObserverMethodImpl)Reflections.cast(method)).getDeclaringBean();
            return manager.getServices().get(SpecializationAndEnablementRegistry.class).isCandidateForLifecycleEvent(declaringBean);
        }
        return true;
    }

    static {
        HashSet<Class<ProcessObserverMethod>> types = new HashSet<Class<ProcessObserverMethod>>();
        types.add(BeforeBeanDiscovery.class);
        types.add(AfterBeanDiscovery.class);
        types.add(AfterDeploymentValidation.class);
        types.add(BeforeShutdown.class);
        types.add(ProcessModule.class);
        types.add(ProcessAnnotatedType.class);
        types.add(ProcessSyntheticAnnotatedType.class);
        types.add(ProcessInjectionPoint.class);
        types.add(ProcessInjectionTarget.class);
        types.add(ProcessProducer.class);
        types.add(ProcessBeanAttributes.class);
        types.add(ProcessBean.class);
        types.add(ProcessSessionBean.class);
        types.add(ProcessManagedBean.class);
        types.add(ProcessProducerMethod.class);
        types.add(ProcessProducerField.class);
        types.add(ProcessObserverMethod.class);
        CONTAINER_LIFECYCLE_EVENT_TYPES = Collections.unmodifiableSet(types);
    }
}

