/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Method;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

public class RuntimeMethodInformation
implements MethodInformation {
    private final Method method;
    private final String descriptor;
    private final String[] parameterTypes;
    private final String returnType;
    private final String declaringClass;
    private final int modifier;

    public RuntimeMethodInformation(Method method) {
        this.method = method;
        this.parameterTypes = DescriptorUtils.getParameterTypes(method);
        this.returnType = DescriptorUtils.classToStringRepresentation(method.getReturnType());
        this.descriptor = DescriptorUtils.getMethodDescriptor(this.parameterTypes, this.returnType);
        this.declaringClass = method.getDeclaringClass().getName();
        int modifier = method.isBridge() ? 4161 : 1;
        if (method.isVarArgs()) {
            modifier |= 0x80;
        }
        this.modifier = modifier;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.method.getName();
    }

    public int getModifiers() {
        return this.modifier;
    }
}

