/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = -5296795345424575659L;
    private ArrayList<E> elements;

    public ArraySet(ArrayList<E> initialList) {
        this.elements = initialList;
    }

    public ArraySet(Collection<E> initialElements) {
        this(initialElements.size());
        this.addAll(initialElements);
    }

    public ArraySet(int size) {
        this.elements = new ArrayList(size);
    }

    public ArraySet() {
        this(5);
    }

    public ArraySet(E ... initialElements) {
        this(initialElements.length);
        this.addAll(initialElements);
    }

    public ArraySet(Collection<E> initialElements, E ... initialElements2) {
        this(initialElements.size() + initialElements2.length);
        this.addAll(initialElements);
        this.addAll(initialElements2);
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        this.elements.add(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> otherCollection) {
        boolean modified = false;
        boolean realSet = otherCollection instanceof Set;
        for (E element : otherCollection) {
            if (!realSet && this.contains(element)) continue;
            this.elements.add(element);
            modified = true;
        }
        this.elements.trimToSize();
        return modified;
    }

    public boolean addAll(E ... elements) {
        boolean modified = false;
        for (E element : elements) {
            modified |= this.add(element);
        }
        return modified;
    }

    public List<E> asList() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    public ArraySet<E> trimToSize() {
        this.elements.trimToSize();
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Set) {
            Object[] otherArray;
            int elementQuantity = this.size();
            if (elementQuantity != (otherArray = ((Set)obj).toArray()).length) {
                return false;
            }
            boolean arraysEqual = true;
            for (int i = 0; i < elementQuantity; ++i) {
                boolean objFound = false;
                for (int j = 0; j < otherArray.length; ++j) {
                    if (!this.elements.get(i).equals(otherArray[j])) continue;
                    objFound = true;
                    break;
                }
                if (objFound) continue;
                arraysEqual = false;
                break;
            }
            return arraysEqual;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return this.elements.toString();
    }
}

