/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formats {
    private static final Function<?> SPACE_DELIMITER_FUNCTION = new Function<Object>(){

        @Override
        public String apply(Object from, int position) {
            if (position > 0) {
                return " " + (from == null ? "null" : from.toString());
            }
            return from == null ? "null" : from.toString();
        }
    };
    private static final Function<?> COMMA_DELIMITER_FUNCTION = new Function<Object>(){

        @Override
        public String apply(Object from, int position) {
            if (position > 0) {
                return ", " + (from == null ? "null" : from.toString());
            }
            return from == null ? "null" : from.toString();
        }
    };
    private static final Function<Annotation> ANNOTATION_LIST_FUNCTION = new Function<Annotation>(){

        @Override
        public String apply(Annotation from, int position) {
            return Formats.spaceDelimiterFunction().apply("@" + from.annotationType().getSimpleName(), position);
        }
    };

    private static <T> Function<T> spaceDelimiterFunction() {
        return SPACE_DELIMITER_FUNCTION;
    }

    private static <T> Function<T> commaDelimiterFunction() {
        return COMMA_DELIMITER_FUNCTION;
    }

    public static String formatType(Type baseType) {
        if (baseType == null) {
            return "null";
        }
        Class rawType = Reflections.getRawType(baseType);
        if (rawType != null) {
            return rawType.getSimpleName() + Formats.formatActualTypeArguments(Reflections.getActualTypeArguments(baseType));
        }
        return baseType.toString();
    }

    public static String formatTypes(Iterable<? extends Type> baseTypes) {
        return Formats.formatIterable(baseTypes, new Function<Type>(){

            @Override
            public String apply(Type from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from), position);
            }
        });
    }

    public static String formatBusinessInterfaceDescriptors(Iterable<? extends BusinessInterfaceDescriptor<?>> businessInterfaceDescriptors) {
        return Formats.formatIterable(businessInterfaceDescriptors, new Function<BusinessInterfaceDescriptor<?>>(){

            @Override
            public String apply(BusinessInterfaceDescriptor<?> from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from.getInterface()), position);
            }
        });
    }

    public static String addSpaceIfNeeded(String string) {
        if (string.length() > 0) {
            return string + " ";
        }
        return string;
    }

    public static String formatAsFormalParameterList(Iterable<? extends AnnotatedParameter<?>> parameters) {
        return "(" + Formats.formatIterable(parameters, new Function<AnnotatedParameter<?>>(){

            @Override
            public String apply(AnnotatedParameter<?> from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatParameter(from), position);
            }
        }) + ")";
    }

    public static String formatParameter(AnnotatedParameter<?> parameter) {
        return Formats.addSpaceIfNeeded(Formats.formatAnnotations(parameter.getAnnotations())) + Formats.formatType(parameter.getBaseType());
    }

    public static String formatModifiers(int modifiers) {
        return Formats.formatIterable(Formats.parseModifiers(modifiers), Formats.spaceDelimiterFunction());
    }

    private static <F> String formatIterable(Iterable<? extends F> items, Function<F> function) {
        if (items == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (F item : items) {
            stringBuilder.append(function.apply(item, i));
            ++i;
        }
        return stringBuilder.toString();
    }

    private static <F> String formatIterable(F[] items, Function<F> function) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (F item : items) {
            stringBuilder.append(function.apply(item, i));
            ++i;
        }
        return stringBuilder.toString();
    }

    private static List<String> parseModifiers(int modifiers) {
        ArrayList<String> result = new ArrayList<String>();
        if (Modifier.isPrivate(modifiers)) {
            result.add("private");
        }
        if (Modifier.isProtected(modifiers)) {
            result.add("protected");
        }
        if (Modifier.isPublic(modifiers)) {
            result.add("public");
        }
        if (Modifier.isAbstract(modifiers)) {
            result.add("abstract");
        }
        if (Modifier.isFinal(modifiers)) {
            result.add("final");
        }
        if (Modifier.isNative(modifiers)) {
            result.add("native");
        }
        if (Modifier.isStatic(modifiers)) {
            result.add("static");
        }
        if (Modifier.isStrict(modifiers)) {
            result.add("strict");
        }
        if (Modifier.isSynchronized(modifiers)) {
            result.add("synchronized");
        }
        if (Modifier.isTransient(modifiers)) {
            result.add("transient");
        }
        if (Modifier.isVolatile(modifiers)) {
            result.add("volatile");
        }
        if (Modifier.isInterface(modifiers)) {
            result.add("interface");
        }
        return result;
    }

    public static String formatActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return Formats.formatActualTypeArguments(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments());
        }
        return "";
    }

    public static String formatActualTypeArguments(Type[] actualTypeArguments) {
        return Formats.wrapIfNeccessary(Formats.formatIterable(actualTypeArguments, new Function<Type>(){

            @Override
            public String apply(Type from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from), position);
            }
        }), "<", ">");
    }

    public static String wrapIfNeccessary(String string, String prepend, String append) {
        if (string != null && string.length() > 0) {
            return prepend + string + append;
        }
        return string;
    }

    public static String formatAnnotations(Iterable<Annotation> annotations) {
        return Formats.formatIterable(annotations, ANNOTATION_LIST_FUNCTION);
    }

    public static String formatAnnotations(Annotation[] annotations) {
        return Formats.formatIterable(annotations, ANNOTATION_LIST_FUNCTION);
    }

    public static String version(Package pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package can not be null");
        }
        return Formats.version(pkg.getSpecificationVersion(), pkg.getImplementationVersion());
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_MIGHT_BE_INFEASIBLE"}, justification="False positive.")
    public static String version(String version, String timestamp) {
        if (version == null && timestamp != null) {
            return timestamp;
        }
        if (version == null && timestamp == null) {
            return "SNAPSHOT";
        }
        String major = null;
        String minor = null;
        String micro = null;
        String qualifier = null;
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        String[] split2 = ((String)split.get(split.size() - 1)).split("\\-");
        if (split2.length > 1) {
            split.remove(split.size() - 1);
            split.add(split.size(), split2[0]);
            qualifier = split2[1];
        } else if (split2.length > 0) {
            split.remove(split.size() - 1);
            qualifier = split2[0];
        }
        if (split.size() > 0) {
            major = (String)split.get(0);
        }
        if (split.size() > 1) {
            minor = (String)split.get(1);
        }
        if (split.size() > 2) {
            micro = (String)split.get(2);
        }
        if (major == null && timestamp != null) {
            return timestamp;
        }
        if (major == null && timestamp == null) {
            return "SNAPSHOT";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(major);
        if (minor != null) {
            builder.append(".").append(minor);
        }
        if (minor != null && micro != null) {
            builder.append(".").append(micro);
        }
        if (qualifier != null) {
            builder.append(" (");
            if (qualifier.equals("SNAPSHOT") && timestamp != null) {
                builder.append(timestamp);
            } else {
                builder.append(qualifier);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static String formatSimpleClassName(Object object) {
        return Formats.formatSimpleClassName(object.getClass());
    }

    public static String formatSimpleClassName(Class<?> javaClass) {
        String simpleName = javaClass.getSimpleName();
        StringBuilder builder = new StringBuilder(simpleName.length() + 2);
        builder.append("[");
        builder.append(simpleName);
        builder.append("]");
        return builder.toString();
    }

    public static String formatAnnotatedType(AnnotatedType<?> type) {
        return Formats.formatSimpleClassName(type) + " " + Formats.addSpaceIfNeeded(Formats.formatModifiers(type.getJavaClass().getModifiers())) + Formats.formatAnnotations(type.getAnnotations()) + " class " + type.getJavaClass().getName() + Formats.formatActualTypeArguments(type.getBaseType());
    }

    public static String formatAnnotatedConstructor(AnnotatedConstructor<?> constructor) {
        return Formats.formatSimpleClassName(constructor) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(constructor.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(constructor.getJavaMember().getModifiers())) + constructor.getDeclaringType().getJavaClass().getName() + Formats.formatAsFormalParameterList(constructor.getParameters());
    }

    public static String formatAnnotatedField(AnnotatedField<?> field) {
        return Formats.formatSimpleClassName(field) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(field.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(field.getJavaMember().getModifiers())) + field.getDeclaringType().getJavaClass().getName() + "." + field.getJavaMember().getName();
    }

    public static String formatAnnotatedMethod(AnnotatedMethod<?> method) {
        return Formats.formatSimpleClassName(method) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(method.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(method.getJavaMember().getModifiers())) + method.getDeclaringType().getJavaClass().getName() + "." + method.getJavaMember().getName() + Formats.formatAsFormalParameterList(method.getParameters());
    }

    public static String formatAnnotatedParameter(AnnotatedParameter<?> parameter) {
        return Formats.formatSimpleClassName(parameter) + " Parameter " + (parameter.getPosition() + 1) + " of " + parameter.getDeclaringCallable().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<F> {
        public String apply(F var1, int var2);
    }
}

