/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVariableResolver {
    private Class<?> beanClass;
    private HashMap<TypeVariable<?>, Type> resolvedVariables;

    public TypeVariableResolver(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass should not be null");
        }
        this.beanClass = beanClass;
    }

    public static Type resolveVariables(Class<?> componentClass, Type type) {
        return new TypeVariableResolver(componentClass).resolveVariablesInType(type);
    }

    public Type resolveVariablesInType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeImpl(parameterizedType.getRawType(), this.resolveVariablesInTypes(parameterizedType.getActualTypeArguments()), parameterizedType.getOwnerType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return this.resolveTypeVariable(typeVariable);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type resolvedComponentType = this.resolveVariablesInType(genericArrayType.getGenericComponentType());
            if (resolvedComponentType instanceof Class) {
                Class componentClass = (Class)resolvedComponentType;
                return Array.newInstance(componentClass, 0).getClass();
            }
            return new GenericArrayTypeImpl(resolvedComponentType);
        }
        return type;
    }

    private Type[] resolveVariablesInTypes(Type[] types) {
        Type[] resolvedTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = this.resolveVariablesInType(types[i]);
        }
        return resolvedTypes;
    }

    private Type resolveTypeVariable(TypeVariable<?> typeVariable) {
        if (this.resolvedVariables == null) {
            this.resolvedVariables = new HashMap();
            this.fillResolvedVariablesMap(this.beanClass);
        }
        return this.resolve(typeVariable);
    }

    private void fillResolvedVariablesMap(Class<?> beanClass) {
        Type genericSuperclass = beanClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedSuperClassType = (ParameterizedType)genericSuperclass;
            Type[] actualTypeArguments = parameterizedSuperClassType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParameters = beanClass.getSuperclass().getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                this.resolvedVariables.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
        if (beanClass.getSuperclass() != null) {
            this.fillResolvedVariablesMap(beanClass.getSuperclass());
        }
    }

    private Type resolve(Type type) {
        TypeVariable typeVariable;
        if (type instanceof TypeVariable && this.resolvedVariables.containsKey(typeVariable = (TypeVariable)type)) {
            return this.resolve(this.resolvedVariables.get(typeVariable));
        }
        return type;
    }
}

