/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractEnhancedAnnotated<T, S>
implements EnhancedAnnotated<T, S> {
    private static final Set<Annotation> DEFAULT_QUALIFIERS = Collections.singleton(DefaultLiteral.INSTANCE);
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Annotated delegate;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static void addMetaAnnotations(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Annotation[] metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractEnhancedAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    protected static void addMetaAnnotations(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Iterable<Annotation> metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractEnhancedAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    private static void addMetaAnnotation(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Class<? extends Annotation> metaAnnotationType, boolean declared) {
        if (declared ? MAPPED_DECLARED_METAANNOTATIONS.contains(metaAnnotationType) : MAPPED_METAANNOTATIONS.contains(metaAnnotationType)) {
            metaAnnotationMap.putSingleElement(metaAnnotationType, annotation);
        }
    }

    public AbstractEnhancedAnnotated(Annotated annotated, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        this.delegate = annotated;
        this.rawType = annotated instanceof AnnotatedType ? ((AnnotatedType)Reflections.cast(annotated)).getJavaClass() : Reflections.getRawType(annotated.getBaseType());
        if (annotationMap == null) {
            throw new WeldException(ReflectionMessage.ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.annotationMap = WeldCollections.immutableMap(annotationMap);
        ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap = new ArraySetMultimap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationMap.values()) {
            AbstractEnhancedAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, classTransformer.getReflectionCache().getAnnotations(annotation.annotationType()), false);
            AbstractEnhancedAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, classTransformer.getTypeStore().get(annotation.annotationType()), false);
        }
        this.metaAnnotationMap = metaAnnotationMap;
        if (declaredAnnotationMap == null) {
            throw new WeldException(ReflectionMessage.DECLARED_ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.actualTypeArguments = this.delegate.getBaseType() instanceof ParameterizedType ? ((ParameterizedType)this.delegate.getBaseType()).getActualTypeArguments() : Arrays2.EMPTY_TYPE_ARRAY;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays2.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
    }

    @Override
    public Set<Type> getInterfaceClosure() {
        HashSet<Type> interfaces = new HashSet<Type>();
        for (Type t : this.getTypeClosure()) {
            if (!Reflections.getRawType(t).isInterface()) continue;
            interfaces.add(t);
        }
        return Collections.unmodifiableSet(interfaces);
    }

    public abstract S getDelegate();

    @Override
    public boolean isParameterizedType() {
        return this.rawType.getTypeParameters().length > 0;
    }

    @Override
    public boolean isPrimitive() {
        return this.getJavaClass().isPrimitive();
    }

    @Override
    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(new ArraySet<Annotation>(this.annotationMap.values()));
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(new ArraySet(this.metaAnnotationMap.get(metaAnnotationType)));
    }

    @Override
    @Deprecated
    public Set<Annotation> getQualifiers() {
        if (this.getMetaAnnotations(Qualifier.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(Qualifier.class));
        }
        return DEFAULT_QUALIFIERS;
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getQualifiers().toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }
}

