/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.util.reflection.Reflections;

public class SlimAnnotatedTypeStoreImpl
implements SlimAnnotatedTypeStore,
BootstrapService {
    private final ConcurrentMap<String, SlimAnnotatedType<?>> typesById = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, List<SlimAnnotatedType<?>>> typesByClass = new MapMaker().makeComputingMap(new Function<Class<?>, List<SlimAnnotatedType<?>>>(){

        @Override
        public List<SlimAnnotatedType<?>> apply(Class<?> input) {
            return new ArrayList(1);
        }
    });

    @Override
    public <X> SlimAnnotatedType<X> get(String id) {
        return (SlimAnnotatedType)Reflections.cast(this.typesById.get(id));
    }

    public <X> List<SlimAnnotatedType<X>> get(Class<X> type) {
        return (List)Reflections.cast(Collections.unmodifiableList((List)this.typesByClass.get(type)));
    }

    @Override
    public <X> void put(SlimAnnotatedType<X> type) {
        SlimAnnotatedType<X> previous = this.typesById.put(type.getID(), type);
        if (previous != null) {
            throw new DeploymentException(BootstrapMessage.DUPLICATE_ANNOTATED_TYPE_ID, type.getID(), type, previous);
        }
        ((List)this.typesByClass.get(type.getJavaClass())).add(type);
    }

    @Override
    public <X> void putIfAbsent(SlimAnnotatedType<X> type) {
        SlimAnnotatedType<X> previousValue = this.typesById.putIfAbsent(type.getID(), type);
        if (previousValue == null) {
            ((List)this.typesByClass.get(type.getJavaClass())).add(type);
        }
    }

    @Override
    public void cleanupAfterBoot() {
        for (SlimAnnotatedType type : this.typesById.values()) {
            type.clear();
        }
    }

    @Override
    public void cleanup() {
        this.typesById.clear();
        this.typesByClass.clear();
    }
}

