/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.bean.ForwardingBean;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ForwardingInterceptor;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.reflection.Reflections;

public abstract class CommonBean<T>
extends ForwardingBeanAttributes<T>
implements Bean<T> {
    public static final String BEAN_ID_PREFIX = RIBean.class.getPackage().getName();
    public static final String BEAN_ID_SEPARATOR = "-";
    private final String id;
    private final int hashCode;
    private volatile BeanAttributes<T> attributes;

    protected CommonBean(BeanAttributes<T> attributes, String idSuffix, BeanManagerImpl beanManager) {
        this.attributes = attributes;
        this.id = BEAN_ID_PREFIX + BEAN_ID_SEPARATOR + beanManager.getId() + BEAN_ID_SEPARATOR + idSuffix;
        this.hashCode = this.id.hashCode();
    }

    protected Object unwrap(Object object) {
        if (object instanceof ForwardingBean) {
            return ((ForwardingBean)Reflections.cast(object)).delegate();
        }
        if (object instanceof ForwardingInterceptor) {
            return ((ForwardingInterceptor)Reflections.cast(object)).delegate();
        }
        if (object instanceof ForwardingDecorator) {
            return ((ForwardingDecorator)Reflections.cast(object)).delegate();
        }
        return object;
    }

    @Override
    public boolean equals(Object obj) {
        Object object = this.unwrap(obj);
        if (object instanceof CommonBean) {
            CommonBean that = (CommonBean)object;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    @Override
    protected BeanAttributes<T> attributes() {
        return this.attributes;
    }

    public void setAttributes(BeanAttributes<T> attributes) {
        this.attributes = attributes;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }
}

