/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class BootstrapConfiguration {
    public static final int DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final long DEFAULT_KEEP_ALIVE_TIME = 60L;
    private static final String CONFIGURATION_FILE = "org.jboss.weld.bootstrap.properties";
    private static final String DEPLOYER_THREADS = "deployerThreads";
    private static final String PRELOADER_THREADS = "preloaderThreads";
    private static final String DEBUG = "debug";
    private static final String ENABLE_THREADING = "enableThreading";
    private static final String THREAD_POOL_TYPE = "threadPoolType";
    private static final String THREAD_POOL_KEEP_ALIVE_TIME = "threadPoolKeepAliveTimeSeconds";
    private final int deployerThreads;
    private final int preloaderThreads;
    private final boolean debug;
    private final boolean threadingEnabled;
    private final ThreadPoolType threadPoolType;
    private final long threadPoolKeepAliveTime;

    public BootstrapConfiguration(ResourceLoader loader) {
        URL configuration = loader.getResource(CONFIGURATION_FILE);
        Properties properties = null;
        if (configuration != null) {
            properties = this.loadProperties(configuration);
        }
        this.deployerThreads = this.initIntValue(properties, DEPLOYER_THREADS, DEFAULT_THREAD_POOL_SIZE);
        this.preloaderThreads = this.initIntValue(properties, PRELOADER_THREADS, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        this.debug = this.initBooleanValue(properties, DEBUG, false);
        this.threadingEnabled = this.initBooleanValue(properties, ENABLE_THREADING, true);
        this.threadPoolType = this.initThreadPoolType(properties, THREAD_POOL_TYPE, ThreadPoolType.FIXED);
        this.threadPoolKeepAliveTime = this.initLongValue(properties, THREAD_POOL_KEEP_ALIVE_TIME, 60L);
    }

    private int initIntValue(Properties properties, String property, int defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException(BootstrapMessage.INVALID_THREAD_POOL_SIZE, value);
        }
    }

    private boolean initBooleanValue(Properties properties, String property, boolean defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        return Boolean.valueOf(properties.getProperty(property));
    }

    private ThreadPoolType initThreadPoolType(Properties properties, String property, ThreadPoolType defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return ThreadPoolType.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException(BootstrapMessage.INVALID_THREAD_POOL_TYPE, value);
        }
    }

    private long initLongValue(Properties properties, String property, long defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException(BootstrapMessage.INVALID_PROPERTY_VALUE, property, value);
        }
    }

    private Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
        return properties;
    }

    public int getDeployerThreads() {
        return this.deployerThreads;
    }

    public int getPreloaderThreads() {
        return this.preloaderThreads;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isThreadingEnabled() {
        return this.threadingEnabled;
    }

    public boolean isConcurrentDeployerEnabled() {
        return this.deployerThreads > 0 && this.threadingEnabled;
    }

    public boolean isPreloaderEnabled() {
        return this.preloaderThreads > 0 && this.threadingEnabled;
    }

    public ThreadPoolType getThreadPoolType() {
        return this.threadPoolType;
    }

    public long getThreadPoolKeepAliveTime() {
        return this.threadPoolKeepAliveTime;
    }

    public static enum ThreadPoolType {
        FIXED,
        FIXED_TIMEOUT;

    }
}

