/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.enablement.EnablementBuilder;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.reflection.Reflections;

public class ExtensionBeanDeployer {
    private final BeanManagerImpl beanManager;
    private final Set<Metadata<Extension>> extensions;
    private final Deployment deployment;
    private final Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private final Collection<ContextHolder<? extends Context>> contexts;
    private final ContainerLifecycleEvents containerLifecycleEventObservers;
    private final EnablementBuilder enablementBuilder;

    public ExtensionBeanDeployer(BeanManagerImpl manager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts, EnablementBuilder enablementBuilder) {
        this.beanManager = manager;
        this.extensions = new HashSet<Metadata<Extension>>();
        this.deployment = deployment;
        this.beanDeployments = beanDeployments;
        this.contexts = contexts;
        this.containerLifecycleEventObservers = this.beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.enablementBuilder = enablementBuilder;
    }

    public ExtensionBeanDeployer deployBeans() {
        ClassTransformer classTransformer = this.beanManager.getServices().get(ClassTransformer.class);
        for (Metadata<Extension> extension : this.extensions) {
            EnhancedAnnotatedType clazz = (EnhancedAnnotatedType)Reflections.cast(classTransformer.getEnhancedAnnotatedType(extension.getValue().getClass()));
            BeanDeployment beanDeployment = DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.beanManager, this.beanDeployments, this.contexts, clazz.getJavaClass(), this.enablementBuilder);
            ExtensionBean bean = new ExtensionBean(beanDeployment.getBeanManager(), clazz, extension);
            HashSet observerMethodInitializers = new HashSet();
            this.createObserverMethods(bean, beanDeployment.getBeanManager(), clazz, observerMethodInitializers);
            beanDeployment.getBeanManager().addBean(bean);
            for (ObserverInitializationContext observerInitializationContext : observerMethodInitializers) {
                observerInitializationContext.initialize();
                beanDeployment.getBeanManager().addObserver(observerInitializationContext.getObserver());
                this.containerLifecycleEventObservers.processObserverMethod(observerInitializationContext.getObserver());
            }
        }
        return this;
    }

    public void addExtensions(Iterable<Metadata<Extension>> extensions) {
        for (Metadata<Extension> extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Metadata<Extension> extension) {
        this.extensions.add(extension);
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedType<? super X> annotatedClass, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, beanManager, enhancedAnnotatedMethod, observerMethodInitializers);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedMethod<T, ? super X> method, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, beanManager);
        ObserverInitializationContext<T, ? super X> observerMethodInitializer = ObserverInitializationContext.of(observer, method);
        observerMethodInitializers.add(observerMethodInitializer);
    }
}

