/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.enablement.EnablementBuilderFragment;
import org.jboss.weld.bootstrap.enablement.ModuleEnablementBuilder;
import org.jboss.weld.logging.messages.ValidatorMessage;

public class EnablementBuilder {
    private final Set<BeanDeployment> deployments = new HashSet<BeanDeployment>();
    private final EnablementBuilderFragment interceptors = new EnablementBuilderFragment(ValidatorMessage.INTERCEPTOR_SPECIFIED_TWICE, ValidatorMessage.GLOBALLY_ENABLED_INTERCEPTOR_NOT_IN_ARCHIVE);
    private final EnablementBuilderFragment decorators = new EnablementBuilderFragment(ValidatorMessage.DECORATOR_SPECIFIED_TWICE, ValidatorMessage.GLOBALLY_ENABLED_DECORATOR_NOT_IN_ARCHIVE);
    private final EnablementBuilderFragment alternatives = new EnablementBuilderFragment(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_SPECIFIED_MULTIPLE_TIMES, ValidatorMessage.GLOBALLY_ENABLED_ALTERNATIVE_NOT_IN_ARCHIVE);
    private boolean initialized;
    private final Map<BeanDeployment, ModuleEnablementBuilder> moduleEnablementBuilders = new HashMap<BeanDeployment, ModuleEnablementBuilder>();

    public void registerBeanDeployment(BeanDeployment deployment) {
        this.deployments.add(deployment);
    }

    protected void processDeployments() {
        for (BeanDeployment deployment : this.deployments) {
            this.interceptors.processGlobalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledInterceptors());
            this.decorators.processGlobalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledDecorators());
            this.alternatives.processGlobalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledAlternatives());
        }
        for (BeanDeployment deployment : this.deployments) {
            this.interceptors.processLocalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledInterceptors());
            this.decorators.processLocalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledDecorators());
            this.alternatives.processLocalRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledAlternatives());
            this.interceptors.processLegacyRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledInterceptors());
            this.decorators.processLegacyRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledDecorators());
            this.alternatives.processLegacyRecords(deployment, deployment.getBeanDeploymentArchive().getBeansXml().getEnabledAlternatives());
        }
        for (BeanDeployment deployment : this.deployments) {
            this.moduleEnablementBuilders.put(deployment, new ModuleEnablementBuilder(this.interceptors.create(deployment), this.decorators.create(deployment), this.alternatives.create(deployment)));
        }
    }

    public ModuleEnablementBuilder getModuleEnablementBuilder(BeanDeployment deployment) {
        if (!this.initialized) {
            this.processDeployments();
            this.initialized = true;
        }
        return this.moduleEnablementBuilders.get(deployment);
    }

    public void clear() {
        this.deployments.clear();
        this.moduleEnablementBuilders.clear();
        this.interceptors.clear();
        this.decorators.clear();
        this.alternatives.clear();
    }
}

