/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.enablement.ClassEnablement;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.EnabledClass;
import org.jboss.weld.bootstrap.spi.EnabledStereotype;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.DefaultValueMap;
import org.slf4j.cal10n.LocLogger;

class EnablementBuilderFragment {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private static final int LOCAL_RECORD_FIRST_ITEM_PRIORITY = 1000;
    private static final int LOCAL_RECORD_PRIORITY_STEP = 10;
    private final ValidatorMessage duplicateRecordMessage;
    private final ValidatorMessage globallyEnabledItemNotInBeanArchiveMessage;
    private final Map<String, GlobalEnablementRecord> globallyEnabledRecords;
    private final Map<String, GlobalEnablementRecord> globallySetPriorities;
    private final Map<BeanDeployment, LocalOverrides> localOverrides;

    EnablementBuilderFragment(ValidatorMessage duplicateRecordMessage, ValidatorMessage globallyEnabledItemNotInBeanArchiveMessage) {
        this.duplicateRecordMessage = duplicateRecordMessage;
        this.globallyEnabledItemNotInBeanArchiveMessage = globallyEnabledItemNotInBeanArchiveMessage;
        this.globallyEnabledRecords = new HashMap<String, GlobalEnablementRecord>();
        this.globallySetPriorities = new HashMap<String, GlobalEnablementRecord>();
        this.localOverrides = DefaultValueMap.hashMapWithDefaultValue(LocalOverrides.SUPPLIER);
    }

    protected void processGlobalRecords(BeanDeployment deployment, List<Metadata<EnabledClass>> records) {
        HashMap<String, Metadata<EnabledClass>> duplicateCheck = new HashMap<String, Metadata<EnabledClass>>();
        Collection<String> beanArchiveClasses = deployment.getBeanDeploymentArchive().getBeanClasses();
        for (Metadata<EnabledClass> item : records) {
            EnabledClass record = item.getValue();
            Metadata<EnabledClass> duplicateItem = duplicateCheck.put(record.getValue(), item);
            if (duplicateItem != null) {
                throw new DeploymentException(this.duplicateRecordMessage, record.getValue(), duplicateItem.getLocation());
            }
            if (record.getPriority() == null) continue;
            int priority = record.getPriority();
            this.validatePriority(priority, item.getLocation());
            Class<?> enabledClass = this.loadClass(item, deployment.getBeanDeployer().getResourceLoader());
            boolean enabledClassFoundWithinArchive = beanArchiveClasses.contains(item.getValue().getValue());
            if (!enabledClassFoundWithinArchive) {
                log.warn(this.globallyEnabledItemNotInBeanArchiveMessage, item.getValue(), deployment.getBeanDeploymentArchive());
            }
            if (record.isEnabled() == null || record.isEnabled().equals(true)) {
                this.globallyEnabledRecords.put(record.getValue(), new GlobalEnablementRecord(item.getLocation(), enabledClass, priority, deployment.getBeanDeploymentArchive()));
                continue;
            }
            this.globallySetPriorities.put(record.getValue(), new GlobalEnablementRecord(item.getLocation(), enabledClass, priority, deployment.getBeanDeploymentArchive()));
        }
    }

    protected void processLocalRecords(BeanDeployment deployment, List<Metadata<EnabledClass>> records) {
        for (Metadata<EnabledClass> item : records) {
            EnabledClass record = item.getValue();
            if (record.getPriority() != null || record.isEnabled() == null) continue;
            Class<?> enabledClass = this.loadClass(item, deployment.getBeanDeployer().getResourceLoader());
            if (record.isEnabled().equals(true)) {
                LocalEnablementRecord enabler = new LocalEnablementRecord(item.getLocation(), enabledClass);
                GlobalEnablementRecord disabledRecordWithPriority = this.globallySetPriorities.get(record.getValue());
                if (disabledRecordWithPriority == null) {
                    throw new DeploymentException(ValidatorMessage.ENABLED_FLAG_USED_WITHOUT_PRIORITY_SET, record.getValue(), item.getLocation());
                }
                this.localOverrides.get(deployment).locallyEnabledRecordsWithDefaultPriority.put(enabler, disabledRecordWithPriority);
                continue;
            }
            LocalEnablementRecord disabler = new LocalEnablementRecord(item.getLocation(), enabledClass);
            GlobalEnablementRecord disabledGlobalRecord = this.globallyEnabledRecords.get(record.getValue());
            if (disabledGlobalRecord == null) {
                log.warn(ValidatorMessage.NO_GLOBALLY_ENABLED_CLASS_MATCHING_LOCAL_DISABLE, record.getValue(), item.getLocation());
                continue;
            }
            this.localOverrides.get(deployment).locallyDisabledRecords.put(disabledGlobalRecord, disabler);
        }
    }

    public void processLegacyRecords(BeanDeployment deployment, List<Metadata<EnabledClass>> records) {
        Map legacyRecords = this.localOverrides.get(deployment).legacyRecords;
        int priority = 1000;
        for (Metadata<EnabledClass> item : records) {
            EnabledClass record = item.getValue();
            if (record.getPriority() != null || record.isEnabled() != null) continue;
            Class<?> enabledClass = this.loadClass(item, deployment.getBeanDeployer().getResourceLoader());
            legacyRecords.put(enabledClass.getName(), new LegacyEnablementRecord(item.getLocation(), enabledClass, priority));
            priority += 10;
        }
    }

    protected void validatePriority(int priority, String location) {
        if (priority < 0 || priority > 3099) {
            log.warn(BootstrapMessage.PRIORITY_OUTSIDE_OF_RECOMMENDED_RANGE, priority, location);
        }
    }

    protected Class<?> loadClass(Metadata<EnabledClass> enabledClassMetadata, ResourceLoader loader) {
        Class<?> clazz = null;
        try {
            clazz = loader.classForName(enabledClassMetadata.getValue().getValue());
        }
        catch (ResourceLoadingException e) {
            throw new DeploymentException(BootstrapMessage.ERROR_LOADING_BEANS_XML_ENTRY, e.getCause(), enabledClassMetadata.getValue().getValue(), enabledClassMetadata.getLocation());
        }
        catch (Exception e) {
            throw new DeploymentException(BootstrapMessage.ERROR_LOADING_BEANS_XML_ENTRY, (Throwable)e, enabledClassMetadata.getValue().getValue(), enabledClassMetadata.getLocation());
        }
        if (enabledClassMetadata.getValue() instanceof EnabledStereotype) {
            if (!clazz.isAnnotation()) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_STEREOTYPE, clazz);
            }
        } else if (clazz.isAnnotation() || clazz.isInterface() || clazz.isEnum()) {
            throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_CLASS, clazz);
        }
        return clazz;
    }

    public List<ClassEnablement> create(BeanDeployment deployment) {
        LocalOverrides overrides = this.localOverrides.get(deployment);
        ArrayList<GlobalEnablementRecord> localRecords = new ArrayList<GlobalEnablementRecord>();
        for (GlobalEnablementRecord globallyEnabledRecord : this.globallyEnabledRecords.values()) {
            BeanDeploymentArchive recordArchive;
            BeanDeploymentArchive deploymentArchive;
            if (overrides.legacyRecords.containsKey(globallyEnabledRecord.getEnabledClass().getName()) || overrides.locallyDisabledRecords.containsKey(globallyEnabledRecord) || !(deploymentArchive = deployment.getBeanDeploymentArchive()).equals(recordArchive = globallyEnabledRecord.getArchive()) && !deploymentArchive.getBeanDeploymentArchives().contains(recordArchive)) continue;
            localRecords.add(globallyEnabledRecord);
        }
        localRecords.addAll(overrides.locallyEnabledRecordsWithDefaultPriority.values());
        localRecords.addAll(overrides.legacyRecords.values());
        Collections.sort(localRecords);
        return new ArrayList<ClassEnablement>(Lists.transform(localRecords, EnablementRecordWithPriorityToClassEnablementFunction.INSTANCE));
    }

    public void clear() {
        this.globallyEnabledRecords.clear();
        this.globallySetPriorities.clear();
        this.localOverrides.clear();
    }

    private static class LegacyEnablementRecord
    extends EnablementRecordWithPriority {
        public LegacyEnablementRecord(String location, Class<?> enabledClass, int priority) {
            super(location, enabledClass, priority);
        }
    }

    private static class LocalEnablementRecord
    extends EnablementRecord {
        public LocalEnablementRecord(String location, Class<?> enabledClass) {
            super(location, enabledClass);
        }
    }

    private static class GlobalEnablementRecord
    extends EnablementRecordWithPriority {
        private final BeanDeploymentArchive archive;

        public GlobalEnablementRecord(String location, Class<?> enabledClass, int priority, BeanDeploymentArchive archive) {
            super(location, enabledClass, priority);
            this.archive = archive;
        }

        public BeanDeploymentArchive getArchive() {
            return this.archive;
        }
    }

    private static abstract class EnablementRecordWithPriority
    extends EnablementRecord
    implements Comparable<EnablementRecordWithPriority> {
        private final int priority;

        public EnablementRecordWithPriority(String location, Class<?> enabledClass, int priority) {
            super(location, enabledClass);
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(EnablementRecordWithPriority o) {
            if (this.priority == o.getPriority()) {
                return this.getEnabledClass().getName().compareTo(o.getEnabledClass().getName());
            }
            return this.priority - o.priority;
        }
    }

    private static abstract class EnablementRecord {
        private final String location;
        private final Class<?> enabledClass;

        public EnablementRecord(String location, Class<?> enabledClass) {
            this.location = location;
            this.enabledClass = enabledClass;
        }

        public String getLocation() {
            return this.location;
        }

        public Class<?> getEnabledClass() {
            return this.enabledClass;
        }
    }

    private static class EnablementRecordWithPriorityToClassEnablementFunction
    implements Function<EnablementRecordWithPriority, ClassEnablement> {
        private static final EnablementRecordWithPriorityToClassEnablementFunction INSTANCE = new EnablementRecordWithPriorityToClassEnablementFunction();

        private EnablementRecordWithPriorityToClassEnablementFunction() {
        }

        @Override
        public ClassEnablement apply(EnablementRecordWithPriority input) {
            if (input instanceof LegacyEnablementRecord) {
                return new ClassEnablement(input.getEnabledClass(), input.getLocation(), null);
            }
            return new ClassEnablement(input.getEnabledClass(), input.getLocation(), input.getPriority());
        }
    }

    private static class LocalOverrides {
        public static final Supplier<LocalOverrides> SUPPLIER = new Supplier<LocalOverrides>(){

            @Override
            public LocalOverrides get() {
                return new LocalOverrides();
            }
        };
        private final Map<String, LegacyEnablementRecord> legacyRecords = new HashMap<String, LegacyEnablementRecord>();
        private final Map<GlobalEnablementRecord, LocalEnablementRecord> locallyDisabledRecords = new HashMap<GlobalEnablementRecord, LocalEnablementRecord>();
        private final Map<LocalEnablementRecord, GlobalEnablementRecord> locallyEnabledRecordsWithDefaultPriority = new HashMap<LocalEnablementRecord, GlobalEnablementRecord>();
    }
}

