/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.weld.bootstrap.BootstrapConfiguration;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.executor.DeamonThreadFactory;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class ContainerLifecycleEventPreloader {
    private final ExecutorService executor;
    private final ObserverNotifier notifier;

    public ContainerLifecycleEventPreloader(BootstrapConfiguration configuration, ObserverNotifier notifier) {
        this.executor = Executors.newFixedThreadPool(configuration.getPreloaderThreads(), new DeamonThreadFactory(new ThreadGroup("weld-preloaders"), "weld-preloader-"));
        this.notifier = notifier;
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="We never need to synchronize with the preloader.")
    void preloadContainerLifecycleEvent(Class<?> eventRawType, Type ... typeParameters) {
        this.executor.submit(new PreloadingTask(new ParameterizedTypeImpl(eventRawType, typeParameters, null)));
    }

    void shutdown() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    private class PreloadingTask
    implements Callable<Void> {
        private final Type type;

        public PreloadingTask(Type type) {
            this.type = type;
        }

        @Override
        public Void call() throws Exception {
            ContainerLifecycleEventPreloader.this.notifier.resolveObserverMethods(this.type, new Annotation[0]);
            return null;
        }
    }
}

